<?php
/**
 * ProgressionsRequest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * AstroAPI
 *
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace AstroAPI\Model;

use \ArrayAccess;
use \AstroAPI\ObjectSerializer;

/**
 * ProgressionsRequest Class Doc Comment
 *
 * @category Class
 * @package  AstroAPI
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProgressionsRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProgressionsRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'birth_date_time' => 'string',
        'birth_location' => '\AstroAPI\Model\Location',
        'target_date' => 'string',
        'house_system' => 'string',
        'language' => 'string',
        'include_text' => 'bool',
        'include_readable_entities' => 'bool',
        'points' => 'string[]',
        'orbs' => 'array<string,float>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'birth_date_time' => null,
        'birth_location' => null,
        'target_date' => null,
        'house_system' => null,
        'language' => null,
        'include_text' => null,
        'include_readable_entities' => null,
        'points' => null,
        'orbs' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'birth_date_time' => false,
        'birth_location' => false,
        'target_date' => false,
        'house_system' => false,
        'language' => false,
        'include_text' => false,
        'include_readable_entities' => false,
        'points' => false,
        'orbs' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'birth_date_time' => 'birthDateTime',
        'birth_location' => 'birthLocation',
        'target_date' => 'targetDate',
        'house_system' => 'houseSystem',
        'language' => 'language',
        'include_text' => 'includeText',
        'include_readable_entities' => 'includeReadableEntities',
        'points' => 'points',
        'orbs' => 'orbs'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'birth_date_time' => 'setBirthDateTime',
        'birth_location' => 'setBirthLocation',
        'target_date' => 'setTargetDate',
        'house_system' => 'setHouseSystem',
        'language' => 'setLanguage',
        'include_text' => 'setIncludeText',
        'include_readable_entities' => 'setIncludeReadableEntities',
        'points' => 'setPoints',
        'orbs' => 'setOrbs'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'birth_date_time' => 'getBirthDateTime',
        'birth_location' => 'getBirthLocation',
        'target_date' => 'getTargetDate',
        'house_system' => 'getHouseSystem',
        'language' => 'getLanguage',
        'include_text' => 'getIncludeText',
        'include_readable_entities' => 'getIncludeReadableEntities',
        'points' => 'getPoints',
        'orbs' => 'getOrbs'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const HOUSE_SYSTEM_PLACIDUS = 'placidus';
    public const HOUSE_SYSTEM_KOCH = 'koch';
    public const HOUSE_SYSTEM_EQUAL = 'equal';
    public const HOUSE_SYSTEM_WHOLE = 'whole';
    public const HOUSE_SYSTEM_CAMPANUS = 'campanus';
    public const HOUSE_SYSTEM_REGIOMONTANUS = 'regiomontanus';
    public const HOUSE_SYSTEM_PORPHYRY = 'porphyry';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getHouseSystemAllowableValues()
    {
        return [
            self::HOUSE_SYSTEM_PLACIDUS,
            self::HOUSE_SYSTEM_KOCH,
            self::HOUSE_SYSTEM_EQUAL,
            self::HOUSE_SYSTEM_WHOLE,
            self::HOUSE_SYSTEM_CAMPANUS,
            self::HOUSE_SYSTEM_REGIOMONTANUS,
            self::HOUSE_SYSTEM_PORPHYRY,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('birth_date_time', $data ?? [], null);
        $this->setIfExists('birth_location', $data ?? [], null);
        $this->setIfExists('target_date', $data ?? [], null);
        $this->setIfExists('house_system', $data ?? [], 'placidus');
        $this->setIfExists('language', $data ?? [], 'en');
        $this->setIfExists('include_text', $data ?? [], true);
        $this->setIfExists('include_readable_entities', $data ?? [], false);
        $this->setIfExists('points', $data ?? [], null);
        $this->setIfExists('orbs', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['birth_date_time'] === null) {
            $invalidProperties[] = "'birth_date_time' can't be null";
        }
        if ($this->container['birth_location'] === null) {
            $invalidProperties[] = "'birth_location' can't be null";
        }
        if ($this->container['target_date'] === null) {
            $invalidProperties[] = "'target_date' can't be null";
        }
        $allowedValues = $this->getHouseSystemAllowableValues();
        if (!is_null($this->container['house_system']) && !in_array($this->container['house_system'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'house_system', must be one of '%s'",
                $this->container['house_system'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets birth_date_time
     *
     * @return string
     */
    public function getBirthDateTime()
    {
        return $this->container['birth_date_time'];
    }

    /**
     * Sets birth_date_time
     *
     * @param string $birth_date_time Birth date and time in YYYY-MM-DDTHH:mm format
     *
     * @return self
     */
    public function setBirthDateTime($birth_date_time)
    {
        if (is_null($birth_date_time)) {
            throw new \InvalidArgumentException('non-nullable birth_date_time cannot be null');
        }
        $this->container['birth_date_time'] = $birth_date_time;

        return $this;
    }

    /**
     * Gets birth_location
     *
     * @return \AstroAPI\Model\Location
     */
    public function getBirthLocation()
    {
        return $this->container['birth_location'];
    }

    /**
     * Sets birth_location
     *
     * @param \AstroAPI\Model\Location $birth_location birth_location
     *
     * @return self
     */
    public function setBirthLocation($birth_location)
    {
        if (is_null($birth_location)) {
            throw new \InvalidArgumentException('non-nullable birth_location cannot be null');
        }
        $this->container['birth_location'] = $birth_location;

        return $this;
    }

    /**
     * Gets target_date
     *
     * @return string
     */
    public function getTargetDate()
    {
        return $this->container['target_date'];
    }

    /**
     * Sets target_date
     *
     * @param string $target_date Target date for progression calculation in YYYY-MM-DDTHH:mm format
     *
     * @return self
     */
    public function setTargetDate($target_date)
    {
        if (is_null($target_date)) {
            throw new \InvalidArgumentException('non-nullable target_date cannot be null');
        }
        $this->container['target_date'] = $target_date;

        return $this;
    }

    /**
     * Gets house_system
     *
     * @return string|null
     */
    public function getHouseSystem()
    {
        return $this->container['house_system'];
    }

    /**
     * Sets house_system
     *
     * @param string|null $house_system House system for calculations (default: \"placidus\")
     *
     * @return self
     */
    public function setHouseSystem($house_system)
    {
        if (is_null($house_system)) {
            throw new \InvalidArgumentException('non-nullable house_system cannot be null');
        }
        $allowedValues = $this->getHouseSystemAllowableValues();
        if (!in_array($house_system, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'house_system', must be one of '%s'",
                    $house_system,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['house_system'] = $house_system;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language Language code for text content
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets include_text
     *
     * @return bool|null
     */
    public function getIncludeText()
    {
        return $this->container['include_text'];
    }

    /**
     * Sets include_text
     *
     * @param bool|null $include_text Include interpretation text
     *
     * @return self
     */
    public function setIncludeText($include_text)
    {
        if (is_null($include_text)) {
            throw new \InvalidArgumentException('non-nullable include_text cannot be null');
        }
        $this->container['include_text'] = $include_text;

        return $this;
    }

    /**
     * Gets include_readable_entities
     *
     * @return bool|null
     */
    public function getIncludeReadableEntities()
    {
        return $this->container['include_readable_entities'];
    }

    /**
     * Sets include_readable_entities
     *
     * @param bool|null $include_readable_entities Include human-readable entity titles
     *
     * @return self
     */
    public function setIncludeReadableEntities($include_readable_entities)
    {
        if (is_null($include_readable_entities)) {
            throw new \InvalidArgumentException('non-nullable include_readable_entities cannot be null');
        }
        $this->container['include_readable_entities'] = $include_readable_entities;

        return $this;
    }

    /**
     * Gets points
     *
     * @return string[]|null
     */
    public function getPoints()
    {
        return $this->container['points'];
    }

    /**
     * Sets points
     *
     * @param string[]|null $points Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.
     *
     * @return self
     */
    public function setPoints($points)
    {
        if (is_null($points)) {
            throw new \InvalidArgumentException('non-nullable points cannot be null');
        }
        $this->container['points'] = $points;

        return $this;
    }

    /**
     * Gets orbs
     *
     * @return array<string,float>|null
     */
    public function getOrbs()
    {
        return $this->container['orbs'];
    }

    /**
     * Sets orbs
     *
     * @param array<string,float>|null $orbs Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })
     *
     * @return self
     */
    public function setOrbs($orbs)
    {
        if (is_null($orbs)) {
            throw new \InvalidArgumentException('non-nullable orbs cannot be null');
        }
        $this->container['orbs'] = $orbs;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


