# astroapi
Professional astrology API for natal charts, transits, synastry, and interpretations

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 25.12.4
- Package version: 1.0.0
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import astroapi
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import astroapi
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.APIKeysApi(api_client)
    id = 'id_example' # str | 

    try:
        # Delete API Key
        api_instance.delete_api_key(id)
    except ApiException as e:
        print("Exception when calling APIKeysApi->delete_api_key: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.astroapi.cloud*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIKeysApi* | [**delete_api_key**](docs/APIKeysApi.md#delete_api_key) | **DELETE** /api/api-keys/{id} | Delete API Key
*APIKeysApi* | [**get_api_api_keys**](docs/APIKeysApi.md#get_api_api_keys) | **GET** /api/api-keys | List API Keys
*APIKeysApi* | [**get_api_api_keys_available_options**](docs/APIKeysApi.md#get_api_api_keys_available_options) | **GET** /api/api-keys/available-options | Available Options
*APIKeysApi* | [**get_api_key**](docs/APIKeysApi.md#get_api_key) | **GET** /api/api-keys/{id} | Get API Key
*APIKeysApi* | [**post_api_api_keys**](docs/APIKeysApi.md#post_api_api_keys) | **POST** /api/api-keys | Create API Key
*APIKeysApi* | [**update_api_key**](docs/APIKeysApi.md#update_api_key) | **PATCH** /api/api-keys/{id} | Update API Key
*CalculationsApi* | [**post_api_calc_chinese_forecast**](docs/CalculationsApi.md#post_api_calc_chinese_forecast) | **POST** /api/calc/chinese-forecast | Chinese Zodiac Forecast
*CalculationsApi* | [**post_api_calc_chinese_horoscope**](docs/CalculationsApi.md#post_api_calc_chinese_horoscope) | **POST** /api/calc/chinese-horoscope | Chinese Zodiac Sign
*CalculationsApi* | [**post_api_calc_compatibility**](docs/CalculationsApi.md#post_api_calc_compatibility) | **POST** /api/calc/compatibility | Compatibility Analysis
*CalculationsApi* | [**post_api_calc_composite**](docs/CalculationsApi.md#post_api_calc_composite) | **POST** /api/calc/composite | Composite Chart
*CalculationsApi* | [**post_api_calc_lunar_return**](docs/CalculationsApi.md#post_api_calc_lunar_return) | **POST** /api/calc/lunar-return | Lunar Return
*CalculationsApi* | [**post_api_calc_moon_sun**](docs/CalculationsApi.md#post_api_calc_moon_sun) | **POST** /api/calc/moon-sun | Moon &amp; Sun Info
*CalculationsApi* | [**post_api_calc_natal**](docs/CalculationsApi.md#post_api_calc_natal) | **POST** /api/calc/natal | Natal Chart
*CalculationsApi* | [**post_api_calc_progressions**](docs/CalculationsApi.md#post_api_calc_progressions) | **POST** /api/calc/progressions | Secondary Progressions
*CalculationsApi* | [**post_api_calc_solar_return**](docs/CalculationsApi.md#post_api_calc_solar_return) | **POST** /api/calc/solar-return | Solar Return
*CalculationsApi* | [**post_api_calc_synastry**](docs/CalculationsApi.md#post_api_calc_synastry) | **POST** /api/calc/synastry | Synastry Chart
*CalculationsApi* | [**post_api_calc_transit**](docs/CalculationsApi.md#post_api_calc_transit) | **POST** /api/calc/transit | Transit Chart
*ChatApi* | [**chat**](docs/ChatApi.md#chat) | **POST** /api/chat/{chatbotId} | Chat with Chatbot
*ChatApi* | [**chat_direct**](docs/ChatApi.md#chat_direct) | **POST** /api/chat/{chatbotId}/direct | Chat with Birth Data
*ChatApi* | [**chat_with_profile**](docs/ChatApi.md#chat_with_profile) | **POST** /api/chat/{chatbotId}/profile/{profileId} | Chat with Profile
*ChatApi* | [**delete_conversation**](docs/ChatApi.md#delete_conversation) | **DELETE** /api/chat/{chatbotId}/conversation/{conversationId} | Delete Conversation
*ChatApi* | [**get_conversation**](docs/ChatApi.md#get_conversation) | **GET** /api/chat/{chatbotId}/conversation/{conversationId} | Get Conversation
*ChatbotApi* | [**create_chat_profile**](docs/ChatbotApi.md#create_chat_profile) | **POST** /api/chatbots/{id}/profiles | Create Chat Profile
*ChatbotApi* | [**create_chatbot**](docs/ChatbotApi.md#create_chatbot) | **POST** /api/chatbots | Create Chatbot
*ChatbotApi* | [**delete_chat_profile**](docs/ChatbotApi.md#delete_chat_profile) | **DELETE** /api/chatbots/{id}/profiles/{profileId} | Delete Chat Profile
*ChatbotApi* | [**delete_chatbot**](docs/ChatbotApi.md#delete_chatbot) | **DELETE** /api/chatbots/{id} | Delete Chatbot
*ChatbotApi* | [**get_chatbot**](docs/ChatbotApi.md#get_chatbot) | **GET** /api/chatbots/{id} | Get Chatbot
*ChatbotApi* | [**get_chatbot_usage**](docs/ChatbotApi.md#get_chatbot_usage) | **GET** /api/chatbots/usage | Get Chatbot Usage
*ChatbotApi* | [**list_chat_profiles**](docs/ChatbotApi.md#list_chat_profiles) | **GET** /api/chatbots/{id}/profiles | List Chat Profiles
*ChatbotApi* | [**list_chatbot_plugins**](docs/ChatbotApi.md#list_chatbot_plugins) | **GET** /api/chatbots/plugins | List Available Plugins
*ChatbotApi* | [**list_chatbots**](docs/ChatbotApi.md#list_chatbots) | **GET** /api/chatbots | List Chatbots
*ChatbotApi* | [**update_chatbot**](docs/ChatbotApi.md#update_chatbot) | **PATCH** /api/chatbots/{id} | Update Chatbot
*ContentApi* | [**create_content**](docs/ContentApi.md#create_content) | **POST** /api/content/{horoscopeType}/{contentType} | Create Content
*ContentApi* | [**create_content_custom_copy**](docs/ContentApi.md#create_content_custom_copy) | **POST** /api/content/{id}/create-custom-copy | Create Custom Copy
*ContentApi* | [**delete_content**](docs/ContentApi.md#delete_content) | **DELETE** /api/content/{horoscopeType}/{contentType}/{id} | Delete Content
*ContentApi* | [**delete_content_by_id**](docs/ContentApi.md#delete_content_by_id) | **DELETE** /api/content/{id} | Delete Content by ID
*ContentApi* | [**get_content**](docs/ContentApi.md#get_content) | **GET** /api/content/{horoscopeType}/{contentType}/{id} | Get Content
*ContentApi* | [**list_content**](docs/ContentApi.md#list_content) | **GET** /api/content/{horoscopeType}/{contentType} | List Content
*ContentApi* | [**restore_content**](docs/ContentApi.md#restore_content) | **POST** /api/content/{id}/restore | Restore Content
*HoroscopeApi* | [**get_daily_horoscopes**](docs/HoroscopeApi.md#get_daily_horoscopes) | **GET** /api/horoscope/daily/{date} | Get Daily Horoscopes
*HoroscopeApi* | [**get_weekly_horoscope**](docs/HoroscopeApi.md#get_weekly_horoscope) | **GET** /api/horoscope/weekly/{year}/{week}/{zodiacSign} | Get Weekly Horoscope Report
*HoroscopeApi* | [**get_yearly_ascendant_horoscope**](docs/HoroscopeApi.md#get_yearly_ascendant_horoscope) | **GET** /api/horoscope/yearly-ascendant/{year}/{zodiacSign} | Get Yearly Ascendant Horoscope Report
*HoroscopeApi* | [**get_yearly_horoscope**](docs/HoroscopeApi.md#get_yearly_horoscope) | **GET** /api/horoscope/yearly/{year}/{zodiacSign} | Get Yearly Horoscope Report
*ModulesApi* | [**get_api_modules**](docs/ModulesApi.md#get_api_modules) | **GET** /api/modules | List Modules
*ModulesApi* | [**get_api_modules_check_module_id**](docs/ModulesApi.md#get_api_modules_check_module_id) | **GET** /api/modules/check/{moduleId} | Check Module Access
*ModulesApi* | [**get_api_modules_organization**](docs/ModulesApi.md#get_api_modules_organization) | **GET** /api/modules/organization | Organization Modules
*ModulesApi* | [**get_api_modules_plans**](docs/ModulesApi.md#get_api_modules_plans) | **GET** /api/modules/plans | Subscription Plans
*NumerologyApi* | [**post_api_numerology_birthday**](docs/NumerologyApi.md#post_api_numerology_birthday) | **POST** /api/numerology/birthday | Birthday Number
*NumerologyApi* | [**post_api_numerology_compatibility**](docs/NumerologyApi.md#post_api_numerology_compatibility) | **POST** /api/numerology/compatibility | Numerology Compatibility
*NumerologyApi* | [**post_api_numerology_expression**](docs/NumerologyApi.md#post_api_numerology_expression) | **POST** /api/numerology/expression | Expression Number
*NumerologyApi* | [**post_api_numerology_life_path**](docs/NumerologyApi.md#post_api_numerology_life_path) | **POST** /api/numerology/life-path | Life Path Number
*NumerologyApi* | [**post_api_numerology_personal_cycles**](docs/NumerologyApi.md#post_api_numerology_personal_cycles) | **POST** /api/numerology/personal-cycles | Personal Cycles
*NumerologyApi* | [**post_api_numerology_personality**](docs/NumerologyApi.md#post_api_numerology_personality) | **POST** /api/numerology/personality | Personality Number
*NumerologyApi* | [**post_api_numerology_profile**](docs/NumerologyApi.md#post_api_numerology_profile) | **POST** /api/numerology/profile | Full Numerology Profile
*NumerologyApi* | [**post_api_numerology_soul_urge**](docs/NumerologyApi.md#post_api_numerology_soul_urge) | **POST** /api/numerology/soul-urge | Soul Urge Number
*OrganizationsApi* | [**delete_api_org_users_member_id**](docs/OrganizationsApi.md#delete_api_org_users_member_id) | **DELETE** /api/org/users/{memberId} | Remove Member
*OrganizationsApi* | [**get_api_org_users**](docs/OrganizationsApi.md#get_api_org_users) | **GET** /api/org/users | List Members
*OrganizationsApi* | [**patch_api_org_users_member_id**](docs/OrganizationsApi.md#patch_api_org_users_member_id) | **PATCH** /api/org/users/{memberId} | Update Member
*OrganizationsApi* | [**post_api_org**](docs/OrganizationsApi.md#post_api_org) | **POST** /api/org | Create Organization
*OrganizationsApi* | [**post_api_org_users**](docs/OrganizationsApi.md#post_api_org_users) | **POST** /api/org/users | Add Member
*WidgetApi* | [**get_widget_config**](docs/WidgetApi.md#get_widget_config) | **GET** /widget/config/{chatbotId} | Get Widget Configuration
*WidgetApi* | [**widget_chat**](docs/WidgetApi.md#widget_chat) | **POST** /widget/chat/{chatbotId} | Widget Chat
*WidgetApi* | [**widget_chat_with_user**](docs/WidgetApi.md#widget_chat_with_user) | **POST** /widget/chat/{chatbotId}/user/{externalUserId} | Widget Chat with User Profile


## Documentation For Models

 - [ApiKey](docs/ApiKey.md)
 - [ApiKey1](docs/ApiKey1.md)
 - [ApiKeyCreated](docs/ApiKeyCreated.md)
 - [ApiKeyModule](docs/ApiKeyModule.md)
 - [ApiKeyOptions](docs/ApiKeyOptions.md)
 - [Aspect](docs/Aspect.md)
 - [Aspect1](docs/Aspect1.md)
 - [CelestialPoint](docs/CelestialPoint.md)
 - [CelestialPoint1](docs/CelestialPoint1.md)
 - [Chart](docs/Chart.md)
 - [ChartEntry](docs/ChartEntry.md)
 - [ChartEntry1](docs/ChartEntry1.md)
 - [ChatDirectRequest](docs/ChatDirectRequest.md)
 - [ChatDirectRequestBirthData](docs/ChatDirectRequestBirthData.md)
 - [ChatRequest](docs/ChatRequest.md)
 - [ChineseForecastData](docs/ChineseForecastData.md)
 - [ChineseForecastRequest](docs/ChineseForecastRequest.md)
 - [ChineseForecastResponse](docs/ChineseForecastResponse.md)
 - [ChineseHoroscopeData](docs/ChineseHoroscopeData.md)
 - [ChineseHoroscopeRequest](docs/ChineseHoroscopeRequest.md)
 - [ChineseHoroscopeResponse](docs/ChineseHoroscopeResponse.md)
 - [CompatibilityData](docs/CompatibilityData.md)
 - [CompatibilityRequest](docs/CompatibilityRequest.md)
 - [CompatibilityResponse](docs/CompatibilityResponse.md)
 - [CompositeData](docs/CompositeData.md)
 - [CompositeRequest](docs/CompositeRequest.md)
 - [CompositeResponse](docs/CompositeResponse.md)
 - [Content](docs/Content.md)
 - [ContentAttributes](docs/ContentAttributes.md)
 - [ContentLinks](docs/ContentLinks.md)
 - [ContentResponse](docs/ContentResponse.md)
 - [CreateApiKeyRequest](docs/CreateApiKeyRequest.md)
 - [CreateChatProfileRequest](docs/CreateChatProfileRequest.md)
 - [CreateChatProfileRequestData](docs/CreateChatProfileRequestData.md)
 - [CreateChatProfileRequestDataAttributes](docs/CreateChatProfileRequestDataAttributes.md)
 - [CreateChatbotRequest](docs/CreateChatbotRequest.md)
 - [CreateChatbotRequestData](docs/CreateChatbotRequestData.md)
 - [CreateChatbotRequestDataAttributes](docs/CreateChatbotRequestDataAttributes.md)
 - [DailyHoroscopeAttributes](docs/DailyHoroscopeAttributes.md)
 - [DailyHoroscopeItem](docs/DailyHoroscopeItem.md)
 - [DailyHoroscopeResponse](docs/DailyHoroscopeResponse.md)
 - [DailyHoroscopeResponseData](docs/DailyHoroscopeResponseData.md)
 - [GetApiApiKeys200Response](docs/GetApiApiKeys200Response.md)
 - [GetApiKey200Response](docs/GetApiKey200Response.md)
 - [GetApiModules200Response](docs/GetApiModules200Response.md)
 - [GetApiModulesOrganization200Response](docs/GetApiModulesOrganization200Response.md)
 - [GetApiModulesPlans200Response](docs/GetApiModulesPlans200Response.md)
 - [GetApiOrgUsers200Response](docs/GetApiOrgUsers200Response.md)
 - [GetApiOrgUsers200ResponseDataInner](docs/GetApiOrgUsers200ResponseDataInner.md)
 - [GetApiOrgUsers200ResponseDataInnerAttributes](docs/GetApiOrgUsers200ResponseDataInnerAttributes.md)
 - [GetApiOrgUsers200ResponseLinks](docs/GetApiOrgUsers200ResponseLinks.md)
 - [GetApiOrgUsers200ResponseMeta](docs/GetApiOrgUsers200ResponseMeta.md)
 - [HoroscopeReportAttributes](docs/HoroscopeReportAttributes.md)
 - [HoroscopeReportResponse](docs/HoroscopeReportResponse.md)
 - [HoroscopeReportResponseData](docs/HoroscopeReportResponseData.md)
 - [Houses](docs/Houses.md)
 - [Location](docs/Location.md)
 - [LunarReturnData](docs/LunarReturnData.md)
 - [LunarReturnRequest](docs/LunarReturnRequest.md)
 - [LunarReturnResponse](docs/LunarReturnResponse.md)
 - [Module](docs/Module.md)
 - [ModuleAccessCheck](docs/ModuleAccessCheck.md)
 - [MoonInfo](docs/MoonInfo.md)
 - [MoonSunData](docs/MoonSunData.md)
 - [MoonSunRequest](docs/MoonSunRequest.md)
 - [MoonSunResponse](docs/MoonSunResponse.md)
 - [NatalData](docs/NatalData.md)
 - [NatalRequest](docs/NatalRequest.md)
 - [NatalResponse](docs/NatalResponse.md)
 - [NumerologyBirthdayRequest](docs/NumerologyBirthdayRequest.md)
 - [NumerologyBirthdayResponse](docs/NumerologyBirthdayResponse.md)
 - [NumerologyCompatibility](docs/NumerologyCompatibility.md)
 - [NumerologyCompatibilityRequest](docs/NumerologyCompatibilityRequest.md)
 - [NumerologyCompatibilityResponse](docs/NumerologyCompatibilityResponse.md)
 - [NumerologyExpressionRequest](docs/NumerologyExpressionRequest.md)
 - [NumerologyExpressionResponse](docs/NumerologyExpressionResponse.md)
 - [NumerologyLifePathRequest](docs/NumerologyLifePathRequest.md)
 - [NumerologyLifePathResponse](docs/NumerologyLifePathResponse.md)
 - [NumerologyNumber](docs/NumerologyNumber.md)
 - [NumerologyNumber1](docs/NumerologyNumber1.md)
 - [NumerologyPersonalCycles](docs/NumerologyPersonalCycles.md)
 - [NumerologyPersonalCyclesRequest](docs/NumerologyPersonalCyclesRequest.md)
 - [NumerologyPersonalCyclesResponse](docs/NumerologyPersonalCyclesResponse.md)
 - [NumerologyPersonalityRequest](docs/NumerologyPersonalityRequest.md)
 - [NumerologyPersonalityResponse](docs/NumerologyPersonalityResponse.md)
 - [NumerologyProfile](docs/NumerologyProfile.md)
 - [NumerologyProfileRequest](docs/NumerologyProfileRequest.md)
 - [NumerologyProfileResponse](docs/NumerologyProfileResponse.md)
 - [NumerologySoulUrgeRequest](docs/NumerologySoulUrgeRequest.md)
 - [NumerologySoulUrgeResponse](docs/NumerologySoulUrgeResponse.md)
 - [PatchApiOrgUsersMemberId200Response](docs/PatchApiOrgUsersMemberId200Response.md)
 - [PatchApiOrgUsersMemberId200ResponseData](docs/PatchApiOrgUsersMemberId200ResponseData.md)
 - [PatchApiOrgUsersMemberIdRequest](docs/PatchApiOrgUsersMemberIdRequest.md)
 - [Permission](docs/Permission.md)
 - [PostApiApiKeys201Response](docs/PostApiApiKeys201Response.md)
 - [PostApiOrgUsers201Response](docs/PostApiOrgUsers201Response.md)
 - [PostApiOrgUsers201ResponseData](docs/PostApiOrgUsers201ResponseData.md)
 - [PostApiOrgUsersRequest](docs/PostApiOrgUsersRequest.md)
 - [ProgressionsData](docs/ProgressionsData.md)
 - [ProgressionsRequest](docs/ProgressionsRequest.md)
 - [ProgressionsResponse](docs/ProgressionsResponse.md)
 - [ReportPeriod](docs/ReportPeriod.md)
 - [SolarReturnData](docs/SolarReturnData.md)
 - [SolarReturnRequest](docs/SolarReturnRequest.md)
 - [SolarReturnResponse](docs/SolarReturnResponse.md)
 - [SubscriptionPlan](docs/SubscriptionPlan.md)
 - [SunInfo](docs/SunInfo.md)
 - [SynastryData](docs/SynastryData.md)
 - [SynastryRequest](docs/SynastryRequest.md)
 - [SynastryResponse](docs/SynastryResponse.md)
 - [TransitData](docs/TransitData.md)
 - [TransitRequest](docs/TransitRequest.md)
 - [TransitResponse](docs/TransitResponse.md)
 - [Twilight](docs/Twilight.md)
 - [TwilightTimes](docs/TwilightTimes.md)
 - [UpdateApiKeyRequest](docs/UpdateApiKeyRequest.md)
 - [UpdateChatbotRequest](docs/UpdateChatbotRequest.md)
 - [UpdateChatbotRequestData](docs/UpdateChatbotRequestData.md)
 - [UpdateChatbotRequestDataAttributes](docs/UpdateChatbotRequestDataAttributes.md)
 - [WidgetChatRequest](docs/WidgetChatRequest.md)
 - [WidgetChatRequestBirthData](docs/WidgetChatRequestBirthData.md)
 - [WidgetChatWithUserRequest](docs/WidgetChatWithUserRequest.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="ApiKeyAuth"></a>
### ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-Api-Key
- **Location**: HTTP header


## Author




