# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ApiKey(BaseModel):
    """
    ApiKey
    """ # noqa: E501
    id: Optional[StrictStr]
    name: Optional[StrictStr]
    prefix: Optional[StrictStr]
    start: Optional[StrictStr]
    organization_id: Optional[StrictStr] = Field(alias="organizationId")
    enabled: StrictBool
    permissions: Optional[List[StrictStr]]
    modules: Optional[List[StrictStr]]
    expires_at: Optional[StrictStr] = Field(alias="expiresAt")
    created_at: Optional[StrictStr] = Field(alias="createdAt")
    updated_at: Optional[StrictStr] = Field(alias="updatedAt")
    rate_limit_enabled: StrictBool = Field(alias="rateLimitEnabled")
    rate_limit_time_window: Optional[Union[StrictFloat, StrictInt]] = Field(alias="rateLimitTimeWindow")
    rate_limit_max: Optional[Union[StrictFloat, StrictInt]] = Field(alias="rateLimitMax")
    request_count: Optional[Union[StrictFloat, StrictInt]] = Field(alias="requestCount")
    last_request: Optional[StrictStr] = Field(alias="lastRequest")
    __properties: ClassVar[List[str]] = ["id", "name", "prefix", "start", "organizationId", "enabled", "permissions", "modules", "expiresAt", "createdAt", "updatedAt", "rateLimitEnabled", "rateLimitTimeWindow", "rateLimitMax", "requestCount", "lastRequest"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if prefix (nullable) is None
        # and model_fields_set contains the field
        if self.prefix is None and "prefix" in self.model_fields_set:
            _dict['prefix'] = None

        # set to None if start (nullable) is None
        # and model_fields_set contains the field
        if self.start is None and "start" in self.model_fields_set:
            _dict['start'] = None

        # set to None if organization_id (nullable) is None
        # and model_fields_set contains the field
        if self.organization_id is None and "organization_id" in self.model_fields_set:
            _dict['organizationId'] = None

        # set to None if permissions (nullable) is None
        # and model_fields_set contains the field
        if self.permissions is None and "permissions" in self.model_fields_set:
            _dict['permissions'] = None

        # set to None if modules (nullable) is None
        # and model_fields_set contains the field
        if self.modules is None and "modules" in self.model_fields_set:
            _dict['modules'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expiresAt'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        # set to None if rate_limit_time_window (nullable) is None
        # and model_fields_set contains the field
        if self.rate_limit_time_window is None and "rate_limit_time_window" in self.model_fields_set:
            _dict['rateLimitTimeWindow'] = None

        # set to None if rate_limit_max (nullable) is None
        # and model_fields_set contains the field
        if self.rate_limit_max is None and "rate_limit_max" in self.model_fields_set:
            _dict['rateLimitMax'] = None

        # set to None if request_count (nullable) is None
        # and model_fields_set contains the field
        if self.request_count is None and "request_count" in self.model_fields_set:
            _dict['requestCount'] = None

        # set to None if last_request (nullable) is None
        # and model_fields_set contains the field
        if self.last_request is None and "last_request" in self.model_fields_set:
            _dict['lastRequest'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "prefix": obj.get("prefix"),
            "start": obj.get("start"),
            "organizationId": obj.get("organizationId"),
            "enabled": obj.get("enabled"),
            "permissions": obj.get("permissions"),
            "modules": obj.get("modules"),
            "expiresAt": obj.get("expiresAt"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "rateLimitEnabled": obj.get("rateLimitEnabled"),
            "rateLimitTimeWindow": obj.get("rateLimitTimeWindow"),
            "rateLimitMax": obj.get("rateLimitMax"),
            "requestCount": obj.get("requestCount"),
            "lastRequest": obj.get("lastRequest")
        })
        return _obj


