# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from astroapi.models.api_key_module import ApiKeyModule
from astroapi.models.permission import Permission
from typing import Optional, Set
from typing_extensions import Self

class ApiKeyOptions(BaseModel):
    """
    ApiKeyOptions
    """ # noqa: E501
    permissions: List[Permission]
    modules: List[ApiKeyModule]
    user_role: Optional[StrictStr] = Field(alias="userRole")
    role_permissions: List[StrictStr] = Field(alias="rolePermissions")
    __properties: ClassVar[List[str]] = ["permissions", "modules", "userRole", "rolePermissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiKeyOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item_permissions in self.permissions:
                if _item_permissions:
                    _items.append(_item_permissions.to_dict())
            _dict['permissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in modules (list)
        _items = []
        if self.modules:
            for _item_modules in self.modules:
                if _item_modules:
                    _items.append(_item_modules.to_dict())
            _dict['modules'] = _items
        # set to None if user_role (nullable) is None
        # and model_fields_set contains the field
        if self.user_role is None and "user_role" in self.model_fields_set:
            _dict['userRole'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiKeyOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "permissions": [Permission.from_dict(_item) for _item in obj["permissions"]] if obj.get("permissions") is not None else None,
            "modules": [ApiKeyModule.from_dict(_item) for _item in obj["modules"]] if obj.get("modules") is not None else None,
            "userRole": obj.get("userRole"),
            "rolePermissions": obj.get("rolePermissions")
        })
        return _obj


