# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Aspect(BaseModel):
    """
    Aspect
    """ # noqa: E501
    point_a: Optional[StrictStr] = Field(alias="pointA")
    point_b: Optional[StrictStr] = Field(alias="pointB")
    aspect: Optional[StrictStr]
    angle: Optional[Union[StrictFloat, StrictInt]]
    orb: Optional[Union[StrictFloat, StrictInt]]
    applying: StrictBool
    text: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["pointA", "pointB", "aspect", "angle", "orb", "applying", "text"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Aspect from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if point_a (nullable) is None
        # and model_fields_set contains the field
        if self.point_a is None and "point_a" in self.model_fields_set:
            _dict['pointA'] = None

        # set to None if point_b (nullable) is None
        # and model_fields_set contains the field
        if self.point_b is None and "point_b" in self.model_fields_set:
            _dict['pointB'] = None

        # set to None if aspect (nullable) is None
        # and model_fields_set contains the field
        if self.aspect is None and "aspect" in self.model_fields_set:
            _dict['aspect'] = None

        # set to None if angle (nullable) is None
        # and model_fields_set contains the field
        if self.angle is None and "angle" in self.model_fields_set:
            _dict['angle'] = None

        # set to None if orb (nullable) is None
        # and model_fields_set contains the field
        if self.orb is None and "orb" in self.model_fields_set:
            _dict['orb'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Aspect from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pointA": obj.get("pointA"),
            "pointB": obj.get("pointB"),
            "aspect": obj.get("aspect"),
            "angle": obj.get("angle"),
            "orb": obj.get("orb"),
            "applying": obj.get("applying"),
            "text": obj.get("text")
        })
        return _obj


