# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CelestialPoint(BaseModel):
    """
    CelestialPoint
    """ # noqa: E501
    point_id: Optional[StrictStr] = Field(alias="pointId")
    longitude: Optional[Union[StrictFloat, StrictInt]]
    speed_longitude: Optional[Union[StrictFloat, StrictInt]] = Field(alias="speedLongitude")
    speed_latitude: Optional[Union[StrictFloat, StrictInt]] = Field(alias="speedLatitude")
    speed_distance: Optional[Union[StrictFloat, StrictInt]] = Field(alias="speedDistance")
    retrograde: StrictBool
    house_id: Optional[StrictStr] = Field(alias="houseId")
    house_number: Optional[Union[StrictFloat, StrictInt]] = Field(alias="houseNumber")
    degrees_in_sign: Optional[Union[StrictFloat, StrictInt]] = Field(alias="degreesInSign")
    degrees_in_sign_dms: List[Optional[Union[StrictFloat, StrictInt]]] = Field(alias="degreesInSignDms")
    sign: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["pointId", "longitude", "speedLongitude", "speedLatitude", "speedDistance", "retrograde", "houseId", "houseNumber", "degreesInSign", "degreesInSignDms", "sign"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CelestialPoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if point_id (nullable) is None
        # and model_fields_set contains the field
        if self.point_id is None and "point_id" in self.model_fields_set:
            _dict['pointId'] = None

        # set to None if longitude (nullable) is None
        # and model_fields_set contains the field
        if self.longitude is None and "longitude" in self.model_fields_set:
            _dict['longitude'] = None

        # set to None if speed_longitude (nullable) is None
        # and model_fields_set contains the field
        if self.speed_longitude is None and "speed_longitude" in self.model_fields_set:
            _dict['speedLongitude'] = None

        # set to None if speed_latitude (nullable) is None
        # and model_fields_set contains the field
        if self.speed_latitude is None and "speed_latitude" in self.model_fields_set:
            _dict['speedLatitude'] = None

        # set to None if speed_distance (nullable) is None
        # and model_fields_set contains the field
        if self.speed_distance is None and "speed_distance" in self.model_fields_set:
            _dict['speedDistance'] = None

        # set to None if house_id (nullable) is None
        # and model_fields_set contains the field
        if self.house_id is None and "house_id" in self.model_fields_set:
            _dict['houseId'] = None

        # set to None if house_number (nullable) is None
        # and model_fields_set contains the field
        if self.house_number is None and "house_number" in self.model_fields_set:
            _dict['houseNumber'] = None

        # set to None if degrees_in_sign (nullable) is None
        # and model_fields_set contains the field
        if self.degrees_in_sign is None and "degrees_in_sign" in self.model_fields_set:
            _dict['degreesInSign'] = None

        # set to None if sign (nullable) is None
        # and model_fields_set contains the field
        if self.sign is None and "sign" in self.model_fields_set:
            _dict['sign'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CelestialPoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pointId": obj.get("pointId"),
            "longitude": obj.get("longitude"),
            "speedLongitude": obj.get("speedLongitude"),
            "speedLatitude": obj.get("speedLatitude"),
            "speedDistance": obj.get("speedDistance"),
            "retrograde": obj.get("retrograde"),
            "houseId": obj.get("houseId"),
            "houseNumber": obj.get("houseNumber"),
            "degreesInSign": obj.get("degreesInSign"),
            "degreesInSignDms": obj.get("degreesInSignDms"),
            "sign": obj.get("sign")
        })
        return _obj


