# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class CelestialPoint1(BaseModel):
    """
    CelestialPoint1
    """ # noqa: E501
    point_id: StrictStr = Field(alias="pointId")
    longitude: Union[StrictFloat, StrictInt]
    speed_longitude: Union[StrictFloat, StrictInt] = Field(alias="speedLongitude")
    speed_latitude: Union[StrictFloat, StrictInt] = Field(alias="speedLatitude")
    speed_distance: Union[StrictFloat, StrictInt] = Field(alias="speedDistance")
    retrograde: StrictBool
    house_id: StrictStr = Field(alias="houseId")
    house_number: Union[StrictFloat, StrictInt] = Field(alias="houseNumber")
    degrees_in_sign: Union[StrictFloat, StrictInt] = Field(alias="degreesInSign")
    degrees_in_sign_dms: List[Union[StrictFloat, StrictInt]] = Field(alias="degreesInSignDms")
    sign: StrictStr
    __properties: ClassVar[List[str]] = ["pointId", "longitude", "speedLongitude", "speedLatitude", "speedDistance", "retrograde", "houseId", "houseNumber", "degreesInSign", "degreesInSignDms", "sign"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CelestialPoint1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CelestialPoint1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pointId": obj.get("pointId"),
            "longitude": obj.get("longitude"),
            "speedLongitude": obj.get("speedLongitude"),
            "speedLatitude": obj.get("speedLatitude"),
            "speedDistance": obj.get("speedDistance"),
            "retrograde": obj.get("retrograde"),
            "houseId": obj.get("houseId"),
            "houseNumber": obj.get("houseNumber"),
            "degreesInSign": obj.get("degreesInSign"),
            "degreesInSignDms": obj.get("degreesInSignDms"),
            "sign": obj.get("sign")
        })
        return _obj


