# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ChineseForecastRequest(BaseModel):
    """
    ChineseForecastRequest
    """ # noqa: E501
    birth_date: StrictStr = Field(description="Birth date in YYYY-MM-DD or ISO 8601 format", alias="birthDate")
    forecast_year: Optional[StrictInt] = Field(default=None, description="Year for forecast. Defaults to current year.", alias="forecastYear")
    language: Optional[StrictStr] = Field(default='en', description="Language code for text content")
    include_text: Optional[StrictBool] = Field(default=True, description="Include interpretation text", alias="includeText")
    include_readable_entities: Optional[StrictBool] = Field(default=False, description="Include human-readable entity titles", alias="includeReadableEntities")
    __properties: ClassVar[List[str]] = ["birthDate", "forecastYear", "language", "includeText", "includeReadableEntities"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChineseForecastRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChineseForecastRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "birthDate": obj.get("birthDate"),
            "forecastYear": obj.get("forecastYear"),
            "language": obj.get("language") if obj.get("language") is not None else 'en',
            "includeText": obj.get("includeText") if obj.get("includeText") is not None else True,
            "includeReadableEntities": obj.get("includeReadableEntities") if obj.get("includeReadableEntities") is not None else False
        })
        return _obj


