# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CompatibilityData(BaseModel):
    """
    CompatibilityData
    """ # noqa: E501
    sign1: Optional[StrictStr]
    sign2: Optional[StrictStr]
    score_based_on_element: Optional[Union[StrictFloat, StrictInt]] = Field(alias="scoreBasedOnElement")
    score_based_on_sun_aspect: Optional[Union[StrictFloat, StrictInt]] = Field(alias="scoreBasedOnSunAspect")
    text: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["sign1", "sign2", "scoreBasedOnElement", "scoreBasedOnSunAspect", "text"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompatibilityData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if sign1 (nullable) is None
        # and model_fields_set contains the field
        if self.sign1 is None and "sign1" in self.model_fields_set:
            _dict['sign1'] = None

        # set to None if sign2 (nullable) is None
        # and model_fields_set contains the field
        if self.sign2 is None and "sign2" in self.model_fields_set:
            _dict['sign2'] = None

        # set to None if score_based_on_element (nullable) is None
        # and model_fields_set contains the field
        if self.score_based_on_element is None and "score_based_on_element" in self.model_fields_set:
            _dict['scoreBasedOnElement'] = None

        # set to None if score_based_on_sun_aspect (nullable) is None
        # and model_fields_set contains the field
        if self.score_based_on_sun_aspect is None and "score_based_on_sun_aspect" in self.model_fields_set:
            _dict['scoreBasedOnSunAspect'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompatibilityData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sign1": obj.get("sign1"),
            "sign2": obj.get("sign2"),
            "scoreBasedOnElement": obj.get("scoreBasedOnElement"),
            "scoreBasedOnSunAspect": obj.get("scoreBasedOnSunAspect"),
            "text": obj.get("text")
        })
        return _obj


