# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateChatProfileRequestDataAttributes(BaseModel):
    """
    CreateChatProfileRequestDataAttributes
    """ # noqa: E501
    external_user_id: Optional[StrictStr] = Field(default=None, alias="externalUserId")
    birth_date: Annotated[str, Field(strict=True)] = Field(alias="birthDate")
    birth_time: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, alias="birthTime")
    birth_place_lat: Optional[Union[StrictFloat, StrictInt]] = Field(alias="birthPlaceLat")
    birth_place_lng: Optional[Union[StrictFloat, StrictInt]] = Field(alias="birthPlaceLng")
    birth_place_name: Optional[StrictStr] = Field(default=None, alias="birthPlaceName")
    timezone: Optional[StrictStr]
    metadata: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["externalUserId", "birthDate", "birthTime", "birthPlaceLat", "birthPlaceLng", "birthPlaceName", "timezone", "metadata"]

    @field_validator('birth_date')
    def birth_date_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\d{4}-\d{2}-\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{4}-\d{2}-\d{2}$/")
        return value

    @field_validator('birth_time')
    def birth_time_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d{2}:\d{2}$", value):
            raise ValueError(r"must validate the regular expression /^\d{2}:\d{2}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateChatProfileRequestDataAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if external_user_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_user_id is None and "external_user_id" in self.model_fields_set:
            _dict['externalUserId'] = None

        # set to None if birth_place_lat (nullable) is None
        # and model_fields_set contains the field
        if self.birth_place_lat is None and "birth_place_lat" in self.model_fields_set:
            _dict['birthPlaceLat'] = None

        # set to None if birth_place_lng (nullable) is None
        # and model_fields_set contains the field
        if self.birth_place_lng is None and "birth_place_lng" in self.model_fields_set:
            _dict['birthPlaceLng'] = None

        # set to None if birth_place_name (nullable) is None
        # and model_fields_set contains the field
        if self.birth_place_name is None and "birth_place_name" in self.model_fields_set:
            _dict['birthPlaceName'] = None

        # set to None if timezone (nullable) is None
        # and model_fields_set contains the field
        if self.timezone is None and "timezone" in self.model_fields_set:
            _dict['timezone'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateChatProfileRequestDataAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "externalUserId": obj.get("externalUserId"),
            "birthDate": obj.get("birthDate"),
            "birthTime": obj.get("birthTime"),
            "birthPlaceLat": obj.get("birthPlaceLat"),
            "birthPlaceLng": obj.get("birthPlaceLng"),
            "birthPlaceName": obj.get("birthPlaceName"),
            "timezone": obj.get("timezone"),
            "metadata": obj.get("metadata")
        })
        return _obj


