# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from astroapi.models.daily_horoscope_item import DailyHoroscopeItem
from typing import Optional, Set
from typing_extensions import Self

class DailyHoroscopeAttributes(BaseModel):
    """
    DailyHoroscopeAttributes
    """ # noqa: E501
    var_date: Optional[StrictStr] = Field(alias="date")
    language: Optional[StrictStr]
    horoscopes: Dict[str, DailyHoroscopeItem]
    __properties: ClassVar[List[str]] = ["date", "language", "horoscopes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DailyHoroscopeAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in horoscopes (dict)
        _field_dict = {}
        if self.horoscopes:
            for _key_horoscopes in self.horoscopes:
                if self.horoscopes[_key_horoscopes]:
                    _field_dict[_key_horoscopes] = self.horoscopes[_key_horoscopes].to_dict()
            _dict['horoscopes'] = _field_dict
        # set to None if var_date (nullable) is None
        # and model_fields_set contains the field
        if self.var_date is None and "var_date" in self.model_fields_set:
            _dict['date'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DailyHoroscopeAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "language": obj.get("language"),
            "horoscopes": dict(
                (_k, DailyHoroscopeItem.from_dict(_v))
                for _k, _v in obj["horoscopes"].items()
            )
            if obj.get("horoscopes") is not None
            else None
        })
        return _obj


