# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from astroapi.models.moon_info import MoonInfo
from astroapi.models.sun_info import SunInfo
from typing import Optional, Set
from typing_extensions import Self

class MoonSunData(BaseModel):
    """
    MoonSunData
    """ # noqa: E501
    moon: MoonInfo
    sun: SunInfo
    __properties: ClassVar[List[str]] = ["moon", "sun"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MoonSunData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of moon
        if self.moon:
            _dict['moon'] = self.moon.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sun
        if self.sun:
            _dict['sun'] = self.sun.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MoonSunData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "moon": MoonInfo.from_dict(obj["moon"]) if obj.get("moon") is not None else None,
            "sun": SunInfo.from_dict(obj["sun"]) if obj.get("sun") is not None else None
        })
        return _obj


