# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from astroapi.models.numerology_number1 import NumerologyNumber1
from typing import Optional, Set
from typing_extensions import Self

class NumerologyCompatibility(BaseModel):
    """
    NumerologyCompatibility
    """ # noqa: E501
    person1_life_path: NumerologyNumber1 = Field(alias="person1LifePath")
    person2_life_path: NumerologyNumber1 = Field(alias="person2LifePath")
    compatibility_score: Optional[Union[StrictFloat, StrictInt]] = Field(alias="compatibilityScore")
    relationship: StrictStr
    description: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["person1LifePath", "person2LifePath", "compatibilityScore", "relationship", "description"]

    @field_validator('relationship')
    def relationship_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['excellent', 'good', 'moderate', 'challenging']):
            raise ValueError("must be one of enum values ('excellent', 'good', 'moderate', 'challenging')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumerologyCompatibility from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of person1_life_path
        if self.person1_life_path:
            _dict['person1LifePath'] = self.person1_life_path.to_dict()
        # override the default output from pydantic by calling `to_dict()` of person2_life_path
        if self.person2_life_path:
            _dict['person2LifePath'] = self.person2_life_path.to_dict()
        # set to None if compatibility_score (nullable) is None
        # and model_fields_set contains the field
        if self.compatibility_score is None and "compatibility_score" in self.model_fields_set:
            _dict['compatibilityScore'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumerologyCompatibility from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "person1LifePath": NumerologyNumber1.from_dict(obj["person1LifePath"]) if obj.get("person1LifePath") is not None else None,
            "person2LifePath": NumerologyNumber1.from_dict(obj["person2LifePath"]) if obj.get("person2LifePath") is not None else None,
            "compatibilityScore": obj.get("compatibilityScore"),
            "relationship": obj.get("relationship"),
            "description": obj.get("description")
        })
        return _obj


