# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from astroapi.models.numerology_number1 import NumerologyNumber1
from typing import Optional, Set
from typing_extensions import Self

class NumerologyPersonalCycles(BaseModel):
    """
    NumerologyPersonalCycles
    """ # noqa: E501
    personal_year: NumerologyNumber1 = Field(alias="personalYear")
    personal_month: NumerologyNumber1 = Field(alias="personalMonth")
    personal_day: NumerologyNumber1 = Field(alias="personalDay")
    __properties: ClassVar[List[str]] = ["personalYear", "personalMonth", "personalDay"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumerologyPersonalCycles from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of personal_year
        if self.personal_year:
            _dict['personalYear'] = self.personal_year.to_dict()
        # override the default output from pydantic by calling `to_dict()` of personal_month
        if self.personal_month:
            _dict['personalMonth'] = self.personal_month.to_dict()
        # override the default output from pydantic by calling `to_dict()` of personal_day
        if self.personal_day:
            _dict['personalDay'] = self.personal_day.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumerologyPersonalCycles from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "personalYear": NumerologyNumber1.from_dict(obj["personalYear"]) if obj.get("personalYear") is not None else None,
            "personalMonth": NumerologyNumber1.from_dict(obj["personalMonth"]) if obj.get("personalMonth") is not None else None,
            "personalDay": NumerologyNumber1.from_dict(obj["personalDay"]) if obj.get("personalDay") is not None else None
        })
        return _obj


