# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from astroapi.models.numerology_number import NumerologyNumber
from astroapi.models.numerology_number1 import NumerologyNumber1
from typing import Optional, Set
from typing_extensions import Self

class NumerologyProfile(BaseModel):
    """
    NumerologyProfile
    """ # noqa: E501
    life_path_number: NumerologyNumber = Field(alias="lifePathNumber")
    expression_number: NumerologyNumber1 = Field(alias="expressionNumber")
    soul_urge_number: NumerologyNumber1 = Field(alias="soulUrgeNumber")
    personality_number: NumerologyNumber1 = Field(alias="personalityNumber")
    birthday_number: NumerologyNumber1 = Field(alias="birthdayNumber")
    personal_year: NumerologyNumber1 = Field(alias="personalYear")
    personal_month: NumerologyNumber1 = Field(alias="personalMonth")
    personal_day: NumerologyNumber1 = Field(alias="personalDay")
    karmic_debt_numbers: List[Union[StrictFloat, StrictInt]] = Field(alias="karmicDebtNumbers")
    master_numbers: List[Union[StrictFloat, StrictInt]] = Field(alias="masterNumbers")
    __properties: ClassVar[List[str]] = ["lifePathNumber", "expressionNumber", "soulUrgeNumber", "personalityNumber", "birthdayNumber", "personalYear", "personalMonth", "personalDay", "karmicDebtNumbers", "masterNumbers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NumerologyProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of life_path_number
        if self.life_path_number:
            _dict['lifePathNumber'] = self.life_path_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expression_number
        if self.expression_number:
            _dict['expressionNumber'] = self.expression_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of soul_urge_number
        if self.soul_urge_number:
            _dict['soulUrgeNumber'] = self.soul_urge_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of personality_number
        if self.personality_number:
            _dict['personalityNumber'] = self.personality_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of birthday_number
        if self.birthday_number:
            _dict['birthdayNumber'] = self.birthday_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of personal_year
        if self.personal_year:
            _dict['personalYear'] = self.personal_year.to_dict()
        # override the default output from pydantic by calling `to_dict()` of personal_month
        if self.personal_month:
            _dict['personalMonth'] = self.personal_month.to_dict()
        # override the default output from pydantic by calling `to_dict()` of personal_day
        if self.personal_day:
            _dict['personalDay'] = self.personal_day.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NumerologyProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lifePathNumber": NumerologyNumber.from_dict(obj["lifePathNumber"]) if obj.get("lifePathNumber") is not None else None,
            "expressionNumber": NumerologyNumber1.from_dict(obj["expressionNumber"]) if obj.get("expressionNumber") is not None else None,
            "soulUrgeNumber": NumerologyNumber1.from_dict(obj["soulUrgeNumber"]) if obj.get("soulUrgeNumber") is not None else None,
            "personalityNumber": NumerologyNumber1.from_dict(obj["personalityNumber"]) if obj.get("personalityNumber") is not None else None,
            "birthdayNumber": NumerologyNumber1.from_dict(obj["birthdayNumber"]) if obj.get("birthdayNumber") is not None else None,
            "personalYear": NumerologyNumber1.from_dict(obj["personalYear"]) if obj.get("personalYear") is not None else None,
            "personalMonth": NumerologyNumber1.from_dict(obj["personalMonth"]) if obj.get("personalMonth") is not None else None,
            "personalDay": NumerologyNumber1.from_dict(obj["personalDay"]) if obj.get("personalDay") is not None else None,
            "karmicDebtNumbers": obj.get("karmicDebtNumbers"),
            "masterNumbers": obj.get("masterNumbers")
        })
        return _obj


