# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from astroapi.models.aspect1 import Aspect1
from astroapi.models.celestial_point1 import CelestialPoint1
from astroapi.models.chart_entry1 import ChartEntry1
from astroapi.models.houses import Houses
from typing import Optional, Set
from typing_extensions import Self

class ProgressionsData(BaseModel):
    """
    ProgressionsData
    """ # noqa: E501
    progressed_date: Optional[StrictStr] = Field(alias="progressedDate")
    natal_date: Optional[StrictStr] = Field(alias="natalDate")
    target_date: Optional[StrictStr] = Field(alias="targetDate")
    aspects: List[Aspect1]
    aspects_to_natal: List[Aspect1] = Field(alias="aspectsToNatal")
    points: Dict[str, CelestialPoint1]
    natal_points: Dict[str, CelestialPoint1] = Field(alias="natalPoints")
    houses: Houses
    charts: Dict[str, ChartEntry1]
    __properties: ClassVar[List[str]] = ["progressedDate", "natalDate", "targetDate", "aspects", "aspectsToNatal", "points", "natalPoints", "houses", "charts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProgressionsData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in aspects (list)
        _items = []
        if self.aspects:
            for _item_aspects in self.aspects:
                if _item_aspects:
                    _items.append(_item_aspects.to_dict())
            _dict['aspects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aspects_to_natal (list)
        _items = []
        if self.aspects_to_natal:
            for _item_aspects_to_natal in self.aspects_to_natal:
                if _item_aspects_to_natal:
                    _items.append(_item_aspects_to_natal.to_dict())
            _dict['aspectsToNatal'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in points (dict)
        _field_dict = {}
        if self.points:
            for _key_points in self.points:
                if self.points[_key_points]:
                    _field_dict[_key_points] = self.points[_key_points].to_dict()
            _dict['points'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in natal_points (dict)
        _field_dict = {}
        if self.natal_points:
            for _key_natal_points in self.natal_points:
                if self.natal_points[_key_natal_points]:
                    _field_dict[_key_natal_points] = self.natal_points[_key_natal_points].to_dict()
            _dict['natalPoints'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of houses
        if self.houses:
            _dict['houses'] = self.houses.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in charts (dict)
        _field_dict = {}
        if self.charts:
            for _key_charts in self.charts:
                if self.charts[_key_charts]:
                    _field_dict[_key_charts] = self.charts[_key_charts].to_dict()
            _dict['charts'] = _field_dict
        # set to None if progressed_date (nullable) is None
        # and model_fields_set contains the field
        if self.progressed_date is None and "progressed_date" in self.model_fields_set:
            _dict['progressedDate'] = None

        # set to None if natal_date (nullable) is None
        # and model_fields_set contains the field
        if self.natal_date is None and "natal_date" in self.model_fields_set:
            _dict['natalDate'] = None

        # set to None if target_date (nullable) is None
        # and model_fields_set contains the field
        if self.target_date is None and "target_date" in self.model_fields_set:
            _dict['targetDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProgressionsData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "progressedDate": obj.get("progressedDate"),
            "natalDate": obj.get("natalDate"),
            "targetDate": obj.get("targetDate"),
            "aspects": [Aspect1.from_dict(_item) for _item in obj["aspects"]] if obj.get("aspects") is not None else None,
            "aspectsToNatal": [Aspect1.from_dict(_item) for _item in obj["aspectsToNatal"]] if obj.get("aspectsToNatal") is not None else None,
            "points": dict(
                (_k, CelestialPoint1.from_dict(_v))
                for _k, _v in obj["points"].items()
            )
            if obj.get("points") is not None
            else None,
            "natalPoints": dict(
                (_k, CelestialPoint1.from_dict(_v))
                for _k, _v in obj["natalPoints"].items()
            )
            if obj.get("natalPoints") is not None
            else None,
            "houses": Houses.from_dict(obj["houses"]) if obj.get("houses") is not None else None,
            "charts": dict(
                (_k, ChartEntry1.from_dict(_v))
                for _k, _v in obj["charts"].items()
            )
            if obj.get("charts") is not None
            else None
        })
        return _obj


