# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from astroapi.models.location import Location
from typing import Optional, Set
from typing_extensions import Self

class SolarReturnRequest(BaseModel):
    """
    SolarReturnRequest
    """ # noqa: E501
    birth_date_time: StrictStr = Field(description="Birth date and time in YYYY-MM-DDTHH:mm format", alias="birthDateTime")
    birth_location: Location = Field(alias="birthLocation")
    return_year: Optional[StrictInt] = Field(default=None, description="Year for solar return calculation. Defaults to current year.", alias="returnYear")
    house_system: Optional[StrictStr] = Field(default='placidus', description="House system for calculations (default: \"placidus\")", alias="houseSystem")
    language: Optional[StrictStr] = Field(default='en', description="Language code for text content")
    include_text: Optional[StrictBool] = Field(default=True, description="Include interpretation text", alias="includeText")
    include_readable_entities: Optional[StrictBool] = Field(default=False, description="Include human-readable entity titles", alias="includeReadableEntities")
    points: Optional[List[StrictStr]] = Field(default=None, description="Celestial points to calculate (e.g., [\"sun\", \"moon\", \"mercury\"]). Defaults to all major planets.")
    orbs: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = Field(default=None, description="Custom orb values per aspect type (e.g., { \"conjunction\": 8, \"opposition\": 6 })")
    __properties: ClassVar[List[str]] = ["birthDateTime", "birthLocation", "returnYear", "houseSystem", "language", "includeText", "includeReadableEntities", "points", "orbs"]

    @field_validator('house_system')
    def house_system_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['placidus', 'koch', 'equal', 'whole', 'campanus', 'regiomontanus', 'porphyry']):
            raise ValueError("must be one of enum values ('placidus', 'koch', 'equal', 'whole', 'campanus', 'regiomontanus', 'porphyry')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SolarReturnRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of birth_location
        if self.birth_location:
            _dict['birthLocation'] = self.birth_location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SolarReturnRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "birthDateTime": obj.get("birthDateTime"),
            "birthLocation": Location.from_dict(obj["birthLocation"]) if obj.get("birthLocation") is not None else None,
            "returnYear": obj.get("returnYear"),
            "houseSystem": obj.get("houseSystem") if obj.get("houseSystem") is not None else 'placidus',
            "language": obj.get("language") if obj.get("language") is not None else 'en',
            "includeText": obj.get("includeText") if obj.get("includeText") is not None else True,
            "includeReadableEntities": obj.get("includeReadableEntities") if obj.get("includeReadableEntities") is not None else False,
            "points": obj.get("points"),
            "orbs": obj.get("orbs")
        })
        return _obj


