# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from astroapi.models.twilight import Twilight
from typing import Optional, Set
from typing_extensions import Self

class SunInfo(BaseModel):
    """
    SunInfo
    """ # noqa: E501
    rise: Optional[StrictStr]
    set: Optional[StrictStr]
    transit: Optional[StrictStr]
    distance: Optional[Union[StrictFloat, StrictInt]]
    diameter_degrees: Optional[Union[StrictFloat, StrictInt]] = Field(alias="diameterDegrees")
    twilight: Twilight
    __properties: ClassVar[List[str]] = ["rise", "set", "transit", "distance", "diameterDegrees", "twilight"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SunInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of twilight
        if self.twilight:
            _dict['twilight'] = self.twilight.to_dict()
        # set to None if rise (nullable) is None
        # and model_fields_set contains the field
        if self.rise is None and "rise" in self.model_fields_set:
            _dict['rise'] = None

        # set to None if set (nullable) is None
        # and model_fields_set contains the field
        if self.set is None and "set" in self.model_fields_set:
            _dict['set'] = None

        # set to None if transit (nullable) is None
        # and model_fields_set contains the field
        if self.transit is None and "transit" in self.model_fields_set:
            _dict['transit'] = None

        # set to None if distance (nullable) is None
        # and model_fields_set contains the field
        if self.distance is None and "distance" in self.model_fields_set:
            _dict['distance'] = None

        # set to None if diameter_degrees (nullable) is None
        # and model_fields_set contains the field
        if self.diameter_degrees is None and "diameter_degrees" in self.model_fields_set:
            _dict['diameterDegrees'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SunInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rise": obj.get("rise"),
            "set": obj.get("set"),
            "transit": obj.get("transit"),
            "distance": obj.get("distance"),
            "diameterDegrees": obj.get("diameterDegrees"),
            "twilight": Twilight.from_dict(obj["twilight"]) if obj.get("twilight") is not None else None
        })
        return _obj


