# coding: utf-8

"""
    AstroAPI

    Professional astrology API for natal charts, transits, synastry, and interpretations

    The version of the OpenAPI document: 25.12.4
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from astroapi.models.aspect1 import Aspect1
from astroapi.models.chart_entry import ChartEntry
from typing import Optional, Set
from typing_extensions import Self

class SynastryData(BaseModel):
    """
    SynastryData
    """ # noqa: E501
    aspects1to2: List[Aspect1]
    aspects2to1: List[Aspect1]
    charts: Dict[str, ChartEntry]
    __properties: ClassVar[List[str]] = ["aspects1to2", "aspects2to1", "charts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SynastryData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in aspects1to2 (list)
        _items = []
        if self.aspects1to2:
            for _item_aspects1to2 in self.aspects1to2:
                if _item_aspects1to2:
                    _items.append(_item_aspects1to2.to_dict())
            _dict['aspects1to2'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aspects2to1 (list)
        _items = []
        if self.aspects2to1:
            for _item_aspects2to1 in self.aspects2to1:
                if _item_aspects2to1:
                    _items.append(_item_aspects2to1.to_dict())
            _dict['aspects2to1'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in charts (dict)
        _field_dict = {}
        if self.charts:
            for _key_charts in self.charts:
                if self.charts[_key_charts]:
                    _field_dict[_key_charts] = self.charts[_key_charts].to_dict()
            _dict['charts'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SynastryData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aspects1to2": [Aspect1.from_dict(_item) for _item in obj["aspects1to2"]] if obj.get("aspects1to2") is not None else None,
            "aspects2to1": [Aspect1.from_dict(_item) for _item in obj["aspects2to1"]] if obj.get("aspects2to1") is not None else None,
            "charts": dict(
                (_k, ChartEntry.from_dict(_v))
                for _k, _v in obj["charts"].items()
            )
            if obj.get("charts") is not None
            else None
        })
        return _obj


