# astroapi.APIKeysApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**delete_api_key**](APIKeysApi.md#delete_api_key) | **DELETE** /api/api-keys/{id} | Delete API Key
[**get_api_api_keys**](APIKeysApi.md#get_api_api_keys) | **GET** /api/api-keys | List API Keys
[**get_api_api_keys_available_options**](APIKeysApi.md#get_api_api_keys_available_options) | **GET** /api/api-keys/available-options | Available Options
[**get_api_key**](APIKeysApi.md#get_api_key) | **GET** /api/api-keys/{id} | Get API Key
[**post_api_api_keys**](APIKeysApi.md#post_api_api_keys) | **POST** /api/api-keys | Create API Key
[**update_api_key**](APIKeysApi.md#update_api_key) | **PATCH** /api/api-keys/{id} | Update API Key


# **delete_api_key**
> delete_api_key(id)

Delete API Key

Permanently delete an API key.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.APIKeysApi(api_client)
    id = 'id_example' # str | 

    try:
        # Delete API Key
        api_instance.delete_api_key(id)
    except Exception as e:
        print("Exception when calling APIKeysApi->delete_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | API key deleted |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_api_api_keys**
> GetApiApiKeys200Response get_api_api_keys()

List API Keys

Get all API keys owned by the current user.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.get_api_api_keys200_response import GetApiApiKeys200Response
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.APIKeysApi(api_client)

    try:
        # List API Keys
        api_response = api_instance.get_api_api_keys()
        print("The response of APIKeysApi->get_api_api_keys:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->get_api_api_keys: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiApiKeys200Response**](GetApiApiKeys200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of API keys |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_api_api_keys_available_options**
> ApiKeyOptions get_api_api_keys_available_options()

Available Options

Get available permissions and modules for configuring API keys.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.api_key_options import ApiKeyOptions
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.APIKeysApi(api_client)

    try:
        # Available Options
        api_response = api_instance.get_api_api_keys_available_options()
        print("The response of APIKeysApi->get_api_api_keys_available_options:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->get_api_api_keys_available_options: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ApiKeyOptions**](ApiKeyOptions.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Available options |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_api_key**
> GetApiKey200Response get_api_key(id)

Get API Key

Get details of a specific API key.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.get_api_key200_response import GetApiKey200Response
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.APIKeysApi(api_client)
    id = 'id_example' # str | 

    try:
        # Get API Key
        api_response = api_instance.get_api_key(id)
        print("The response of APIKeysApi->get_api_key:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->get_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

[**GetApiKey200Response**](GetApiKey200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | API key details |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_api_keys**
> PostApiApiKeys201Response post_api_api_keys(create_api_key_request=create_api_key_request)

Create API Key

Create a new API key with optional permission and module restrictions.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.create_api_key_request import CreateApiKeyRequest
from astroapi.models.post_api_api_keys201_response import PostApiApiKeys201Response
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.APIKeysApi(api_client)
    create_api_key_request = astroapi.CreateApiKeyRequest() # CreateApiKeyRequest |  (optional)

    try:
        # Create API Key
        api_response = api_instance.post_api_api_keys(create_api_key_request=create_api_key_request)
        print("The response of APIKeysApi->post_api_api_keys:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->post_api_api_keys: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_api_key_request** | [**CreateApiKeyRequest**](CreateApiKeyRequest.md)|  | [optional] 

### Return type

[**PostApiApiKeys201Response**](PostApiApiKeys201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | API key created |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_api_key**
> GetApiKey200Response update_api_key(id, update_api_key_request=update_api_key_request)

Update API Key

Update an API key's name, status, permissions, or modules.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.get_api_key200_response import GetApiKey200Response
from astroapi.models.update_api_key_request import UpdateApiKeyRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.APIKeysApi(api_client)
    id = 'id_example' # str | 
    update_api_key_request = astroapi.UpdateApiKeyRequest() # UpdateApiKeyRequest |  (optional)

    try:
        # Update API Key
        api_response = api_instance.update_api_key(id, update_api_key_request=update_api_key_request)
        print("The response of APIKeysApi->update_api_key:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling APIKeysApi->update_api_key: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **update_api_key_request** | [**UpdateApiKeyRequest**](UpdateApiKeyRequest.md)|  | [optional] 

### Return type

[**GetApiKey200Response**](GetApiKey200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | API key updated |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

