# astroapi.CalculationsApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**post_api_calc_chinese_forecast**](CalculationsApi.md#post_api_calc_chinese_forecast) | **POST** /api/calc/chinese-forecast | Chinese Zodiac Forecast
[**post_api_calc_chinese_horoscope**](CalculationsApi.md#post_api_calc_chinese_horoscope) | **POST** /api/calc/chinese-horoscope | Chinese Zodiac Sign
[**post_api_calc_compatibility**](CalculationsApi.md#post_api_calc_compatibility) | **POST** /api/calc/compatibility | Compatibility Analysis
[**post_api_calc_composite**](CalculationsApi.md#post_api_calc_composite) | **POST** /api/calc/composite | Composite Chart
[**post_api_calc_lunar_return**](CalculationsApi.md#post_api_calc_lunar_return) | **POST** /api/calc/lunar-return | Lunar Return
[**post_api_calc_moon_sun**](CalculationsApi.md#post_api_calc_moon_sun) | **POST** /api/calc/moon-sun | Moon &amp; Sun Info
[**post_api_calc_natal**](CalculationsApi.md#post_api_calc_natal) | **POST** /api/calc/natal | Natal Chart
[**post_api_calc_progressions**](CalculationsApi.md#post_api_calc_progressions) | **POST** /api/calc/progressions | Secondary Progressions
[**post_api_calc_solar_return**](CalculationsApi.md#post_api_calc_solar_return) | **POST** /api/calc/solar-return | Solar Return
[**post_api_calc_synastry**](CalculationsApi.md#post_api_calc_synastry) | **POST** /api/calc/synastry | Synastry Chart
[**post_api_calc_transit**](CalculationsApi.md#post_api_calc_transit) | **POST** /api/calc/transit | Transit Chart


# **post_api_calc_chinese_forecast**
> ChineseForecastResponse post_api_calc_chinese_forecast(chinese_forecast_request=chinese_forecast_request)

Chinese Zodiac Forecast

Get Chinese zodiac forecast for a specific year with category breakdowns.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.chinese_forecast_request import ChineseForecastRequest
from astroapi.models.chinese_forecast_response import ChineseForecastResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    chinese_forecast_request = astroapi.ChineseForecastRequest() # ChineseForecastRequest |  (optional)

    try:
        # Chinese Zodiac Forecast
        api_response = api_instance.post_api_calc_chinese_forecast(chinese_forecast_request=chinese_forecast_request)
        print("The response of CalculationsApi->post_api_calc_chinese_forecast:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_chinese_forecast: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chinese_forecast_request** | [**ChineseForecastRequest**](ChineseForecastRequest.md)|  | [optional] 

### Return type

[**ChineseForecastResponse**](ChineseForecastResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate Chinese horoscope forecast |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_chinese_horoscope**
> ChineseHoroscopeResponse post_api_calc_chinese_horoscope(chinese_horoscope_request=chinese_horoscope_request)

Chinese Zodiac Sign

Calculate the Chinese zodiac sign and element based on birth year.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.chinese_horoscope_request import ChineseHoroscopeRequest
from astroapi.models.chinese_horoscope_response import ChineseHoroscopeResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    chinese_horoscope_request = astroapi.ChineseHoroscopeRequest() # ChineseHoroscopeRequest |  (optional)

    try:
        # Chinese Zodiac Sign
        api_response = api_instance.post_api_calc_chinese_horoscope(chinese_horoscope_request=chinese_horoscope_request)
        print("The response of CalculationsApi->post_api_calc_chinese_horoscope:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_chinese_horoscope: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chinese_horoscope_request** | [**ChineseHoroscopeRequest**](ChineseHoroscopeRequest.md)|  | [optional] 

### Return type

[**ChineseHoroscopeResponse**](ChineseHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate Chinese horoscope sign |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_compatibility**
> CompatibilityResponse post_api_calc_compatibility(compatibility_request=compatibility_request)

Compatibility Analysis

Calculate sun sign compatibility between two people with interpretation text.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.compatibility_request import CompatibilityRequest
from astroapi.models.compatibility_response import CompatibilityResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    compatibility_request = astroapi.CompatibilityRequest() # CompatibilityRequest |  (optional)

    try:
        # Compatibility Analysis
        api_response = api_instance.post_api_calc_compatibility(compatibility_request=compatibility_request)
        print("The response of CalculationsApi->post_api_calc_compatibility:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_compatibility: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **compatibility_request** | [**CompatibilityRequest**](CompatibilityRequest.md)|  | [optional] 

### Return type

[**CompatibilityResponse**](CompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate compatibility between two birth charts |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_composite**
> CompositeResponse post_api_calc_composite(composite_request=composite_request)

Composite Chart

Calculate a composite chart by combining midpoints of two birth charts.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.composite_request import CompositeRequest
from astroapi.models.composite_response import CompositeResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    composite_request = astroapi.CompositeRequest() # CompositeRequest |  (optional)

    try:
        # Composite Chart
        api_response = api_instance.post_api_calc_composite(composite_request=composite_request)
        print("The response of CalculationsApi->post_api_calc_composite:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_composite: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **composite_request** | [**CompositeRequest**](CompositeRequest.md)|  | [optional] 

### Return type

[**CompositeResponse**](CompositeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate composite chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_lunar_return**
> LunarReturnResponse post_api_calc_lunar_return(lunar_return_request=lunar_return_request)

Lunar Return

Calculate the lunar return chart when the Moon returns to its natal position.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.lunar_return_request import LunarReturnRequest
from astroapi.models.lunar_return_response import LunarReturnResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    lunar_return_request = astroapi.LunarReturnRequest() # LunarReturnRequest |  (optional)

    try:
        # Lunar Return
        api_response = api_instance.post_api_calc_lunar_return(lunar_return_request=lunar_return_request)
        print("The response of CalculationsApi->post_api_calc_lunar_return:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_lunar_return: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **lunar_return_request** | [**LunarReturnRequest**](LunarReturnRequest.md)|  | [optional] 

### Return type

[**LunarReturnResponse**](LunarReturnResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate lunar return chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_moon_sun**
> MoonSunResponse post_api_calc_moon_sun(moon_sun_request=moon_sun_request)

Moon & Sun Info

Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.moon_sun_request import MoonSunRequest
from astroapi.models.moon_sun_response import MoonSunResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    moon_sun_request = astroapi.MoonSunRequest() # MoonSunRequest |  (optional)

    try:
        # Moon & Sun Info
        api_response = api_instance.post_api_calc_moon_sun(moon_sun_request=moon_sun_request)
        print("The response of CalculationsApi->post_api_calc_moon_sun:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_moon_sun: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **moon_sun_request** | [**MoonSunRequest**](MoonSunRequest.md)|  | [optional] 

### Return type

[**MoonSunResponse**](MoonSunResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Moon and Sun information |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_natal**
> NatalResponse post_api_calc_natal(natal_request=natal_request)

Natal Chart

Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.natal_request import NatalRequest
from astroapi.models.natal_response import NatalResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    natal_request = astroapi.NatalRequest() # NatalRequest |  (optional)

    try:
        # Natal Chart
        api_response = api_instance.post_api_calc_natal(natal_request=natal_request)
        print("The response of CalculationsApi->post_api_calc_natal:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_natal: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **natal_request** | [**NatalRequest**](NatalRequest.md)|  | [optional] 

### Return type

[**NatalResponse**](NatalResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate natal chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_progressions**
> ProgressionsResponse post_api_calc_progressions(progressions_request=progressions_request)

Secondary Progressions

Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.progressions_request import ProgressionsRequest
from astroapi.models.progressions_response import ProgressionsResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    progressions_request = astroapi.ProgressionsRequest() # ProgressionsRequest |  (optional)

    try:
        # Secondary Progressions
        api_response = api_instance.post_api_calc_progressions(progressions_request=progressions_request)
        print("The response of CalculationsApi->post_api_calc_progressions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_progressions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **progressions_request** | [**ProgressionsRequest**](ProgressionsRequest.md)|  | [optional] 

### Return type

[**ProgressionsResponse**](ProgressionsResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate secondary progressions chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_solar_return**
> SolarReturnResponse post_api_calc_solar_return(solar_return_request=solar_return_request)

Solar Return

Calculate the solar return chart for a specific year (birthday chart).

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.solar_return_request import SolarReturnRequest
from astroapi.models.solar_return_response import SolarReturnResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    solar_return_request = astroapi.SolarReturnRequest() # SolarReturnRequest |  (optional)

    try:
        # Solar Return
        api_response = api_instance.post_api_calc_solar_return(solar_return_request=solar_return_request)
        print("The response of CalculationsApi->post_api_calc_solar_return:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_solar_return: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **solar_return_request** | [**SolarReturnRequest**](SolarReturnRequest.md)|  | [optional] 

### Return type

[**SolarReturnResponse**](SolarReturnResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate solar return chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_synastry**
> SynastryResponse post_api_calc_synastry(synastry_request=synastry_request)

Synastry Chart

Calculate synastry aspects between two birth charts for relationship analysis.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.synastry_request import SynastryRequest
from astroapi.models.synastry_response import SynastryResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    synastry_request = astroapi.SynastryRequest() # SynastryRequest |  (optional)

    try:
        # Synastry Chart
        api_response = api_instance.post_api_calc_synastry(synastry_request=synastry_request)
        print("The response of CalculationsApi->post_api_calc_synastry:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_synastry: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **synastry_request** | [**SynastryRequest**](SynastryRequest.md)|  | [optional] 

### Return type

[**SynastryResponse**](SynastryResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate synastry chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_calc_transit**
> TransitResponse post_api_calc_transit(transit_request=transit_request)

Transit Chart

Calculate planetary transits over a natal chart for a specified time period.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.transit_request import TransitRequest
from astroapi.models.transit_response import TransitResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.CalculationsApi(api_client)
    transit_request = astroapi.TransitRequest() # TransitRequest |  (optional)

    try:
        # Transit Chart
        api_response = api_instance.post_api_calc_transit(transit_request=transit_request)
        print("The response of CalculationsApi->post_api_calc_transit:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CalculationsApi->post_api_calc_transit: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transit_request** | [**TransitRequest**](TransitRequest.md)|  | [optional] 

### Return type

[**TransitResponse**](TransitResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Calculate transits chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

