# astroapi.ChatApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**chat**](ChatApi.md#chat) | **POST** /api/chat/{chatbotId} | Chat with Chatbot
[**chat_direct**](ChatApi.md#chat_direct) | **POST** /api/chat/{chatbotId}/direct | Chat with Birth Data
[**chat_with_profile**](ChatApi.md#chat_with_profile) | **POST** /api/chat/{chatbotId}/profile/{profileId} | Chat with Profile
[**delete_conversation**](ChatApi.md#delete_conversation) | **DELETE** /api/chat/{chatbotId}/conversation/{conversationId} | Delete Conversation
[**get_conversation**](ChatApi.md#get_conversation) | **GET** /api/chat/{chatbotId}/conversation/{conversationId} | Get Conversation


# **chat**
> object chat(chatbot_id, chat_request=chat_request)

Chat with Chatbot

Send a message to a chatbot and receive a streaming response via SSE

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.chat_request import ChatRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 
    chat_request = astroapi.ChatRequest() # ChatRequest |  (optional)

    try:
        # Chat with Chatbot
        api_response = api_instance.chat(chatbot_id, chat_request=chat_request)
        print("The response of ChatApi->chat:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatApi->chat: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 
 **chat_request** | [**ChatRequest**](ChatRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: text/event-stream

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SSE stream with chat response |  -  |
**404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **chat_direct**
> object chat_direct(chatbot_id, chat_direct_request=chat_direct_request)

Chat with Birth Data

Send a message with inline birth data (no profile needed)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.chat_direct_request import ChatDirectRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 
    chat_direct_request = astroapi.ChatDirectRequest() # ChatDirectRequest |  (optional)

    try:
        # Chat with Birth Data
        api_response = api_instance.chat_direct(chatbot_id, chat_direct_request=chat_direct_request)
        print("The response of ChatApi->chat_direct:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatApi->chat_direct: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 
 **chat_direct_request** | [**ChatDirectRequest**](ChatDirectRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: text/event-stream

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SSE stream with chat response |  -  |
**404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **chat_with_profile**
> object chat_with_profile(chatbot_id, profile_id, chat_request=chat_request)

Chat with Profile

Send a message using a pre-configured user profile

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.chat_request import ChatRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 
    profile_id = 'profile_id_example' # str | 
    chat_request = astroapi.ChatRequest() # ChatRequest |  (optional)

    try:
        # Chat with Profile
        api_response = api_instance.chat_with_profile(chatbot_id, profile_id, chat_request=chat_request)
        print("The response of ChatApi->chat_with_profile:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatApi->chat_with_profile: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 
 **profile_id** | **str**|  | 
 **chat_request** | [**ChatRequest**](ChatRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: text/event-stream

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SSE stream with chat response |  -  |
**404** | Chatbot or profile not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_conversation**
> delete_conversation(chatbot_id, conversation_id)

Delete Conversation

Delete a conversation and its history

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 
    conversation_id = 'conversation_id_example' # str | 

    try:
        # Delete Conversation
        api_instance.delete_conversation(chatbot_id, conversation_id)
    except Exception as e:
        print("Exception when calling ChatApi->delete_conversation: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 
 **conversation_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Conversation deleted |  -  |
**404** | Conversation not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_conversation**
> get_conversation(chatbot_id, conversation_id)

Get Conversation

Retrieve conversation history

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 
    conversation_id = 'conversation_id_example' # str | 

    try:
        # Get Conversation
        api_instance.get_conversation(chatbot_id, conversation_id)
    except Exception as e:
        print("Exception when calling ChatApi->get_conversation: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 
 **conversation_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Conversation data |  -  |
**404** | Conversation not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

