# astroapi.ChatbotApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_chat_profile**](ChatbotApi.md#create_chat_profile) | **POST** /api/chatbots/{id}/profiles | Create Chat Profile
[**create_chatbot**](ChatbotApi.md#create_chatbot) | **POST** /api/chatbots | Create Chatbot
[**delete_chat_profile**](ChatbotApi.md#delete_chat_profile) | **DELETE** /api/chatbots/{id}/profiles/{profileId} | Delete Chat Profile
[**delete_chatbot**](ChatbotApi.md#delete_chatbot) | **DELETE** /api/chatbots/{id} | Delete Chatbot
[**get_chatbot**](ChatbotApi.md#get_chatbot) | **GET** /api/chatbots/{id} | Get Chatbot
[**get_chatbot_usage**](ChatbotApi.md#get_chatbot_usage) | **GET** /api/chatbots/usage | Get Chatbot Usage
[**list_chat_profiles**](ChatbotApi.md#list_chat_profiles) | **GET** /api/chatbots/{id}/profiles | List Chat Profiles
[**list_chatbot_plugins**](ChatbotApi.md#list_chatbot_plugins) | **GET** /api/chatbots/plugins | List Available Plugins
[**list_chatbots**](ChatbotApi.md#list_chatbots) | **GET** /api/chatbots | List Chatbots
[**update_chatbot**](ChatbotApi.md#update_chatbot) | **PATCH** /api/chatbots/{id} | Update Chatbot


# **create_chat_profile**
> object create_chat_profile(id, create_chat_profile_request=create_chat_profile_request)

Create Chat Profile

Create a pre-configured chat profile with birth data

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.create_chat_profile_request import CreateChatProfileRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)
    id = 'id_example' # str | 
    create_chat_profile_request = astroapi.CreateChatProfileRequest() # CreateChatProfileRequest |  (optional)

    try:
        # Create Chat Profile
        api_response = api_instance.create_chat_profile(id, create_chat_profile_request=create_chat_profile_request)
        print("The response of ChatbotApi->create_chat_profile:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->create_chat_profile: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **create_chat_profile_request** | [**CreateChatProfileRequest**](CreateChatProfileRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created profile |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_chatbot**
> object create_chatbot(create_chatbot_request=create_chatbot_request)

Create Chatbot

Create a new chatbot for the organization

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.create_chatbot_request import CreateChatbotRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)
    create_chatbot_request = astroapi.CreateChatbotRequest() # CreateChatbotRequest |  (optional)

    try:
        # Create Chatbot
        api_response = api_instance.create_chatbot(create_chatbot_request=create_chatbot_request)
        print("The response of ChatbotApi->create_chatbot:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->create_chatbot: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **create_chatbot_request** | [**CreateChatbotRequest**](CreateChatbotRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created chatbot |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_chat_profile**
> delete_chat_profile(id, profile_id)

Delete Chat Profile

Delete a chat profile

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)
    id = 'id_example' # str | 
    profile_id = 'profile_id_example' # str | 

    try:
        # Delete Chat Profile
        api_instance.delete_chat_profile(id, profile_id)
    except Exception as e:
        print("Exception when calling ChatbotApi->delete_chat_profile: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **profile_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Profile deleted |  -  |
**404** | Profile not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_chatbot**
> delete_chatbot(id)

Delete Chatbot

Delete a chatbot

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)
    id = 'id_example' # str | 

    try:
        # Delete Chatbot
        api_instance.delete_chatbot(id)
    except Exception as e:
        print("Exception when calling ChatbotApi->delete_chatbot: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Chatbot deleted |  -  |
**404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_chatbot**
> object get_chatbot(id)

Get Chatbot

Get a specific chatbot by ID

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)
    id = 'id_example' # str | 

    try:
        # Get Chatbot
        api_response = api_instance.get_chatbot(id)
        print("The response of ChatbotApi->get_chatbot:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->get_chatbot: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Chatbot details |  -  |
**404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_chatbot_usage**
> object get_chatbot_usage()

Get Chatbot Usage

Get chatbot usage statistics for the current organization

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)

    try:
        # Get Chatbot Usage
        api_response = api_instance.get_chatbot_usage()
        print("The response of ChatbotApi->get_chatbot_usage:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->get_chatbot_usage: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Usage statistics |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_chat_profiles**
> object list_chat_profiles(id)

List Chat Profiles

List all chat profiles for a chatbot

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)
    id = 'id_example' # str | 

    try:
        # List Chat Profiles
        api_response = api_instance.list_chat_profiles(id)
        print("The response of ChatbotApi->list_chat_profiles:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->list_chat_profiles: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of profiles |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_chatbot_plugins**
> object list_chatbot_plugins()

List Available Plugins

List all available chatbot plugins

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)

    try:
        # List Available Plugins
        api_response = api_instance.list_chatbot_plugins()
        print("The response of ChatbotApi->list_chatbot_plugins:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->list_chatbot_plugins: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of plugins |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_chatbots**
> object list_chatbots()

List Chatbots

List all chatbots for the current organization

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)

    try:
        # List Chatbots
        api_response = api_instance.list_chatbots()
        print("The response of ChatbotApi->list_chatbots:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->list_chatbots: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of chatbots |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_chatbot**
> object update_chatbot(id, update_chatbot_request=update_chatbot_request)

Update Chatbot

Update an existing chatbot

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.update_chatbot_request import UpdateChatbotRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ChatbotApi(api_client)
    id = 'id_example' # str | 
    update_chatbot_request = astroapi.UpdateChatbotRequest() # UpdateChatbotRequest |  (optional)

    try:
        # Update Chatbot
        api_response = api_instance.update_chatbot(id, update_chatbot_request=update_chatbot_request)
        print("The response of ChatbotApi->update_chatbot:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ChatbotApi->update_chatbot: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **update_chatbot_request** | [**UpdateChatbotRequest**](UpdateChatbotRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Updated chatbot |  -  |
**404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

