# CompositeRequest


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**date_time1** | **str** | First person birth date/time in YYYY-MM-DDTHH:mm format | 
**location1** | [**Location**](Location.md) |  | 
**date_time2** | **str** | Second person birth date/time in YYYY-MM-DDTHH:mm format | 
**location2** | [**Location**](Location.md) |  | 
**house_system** | **str** | House system for calculations (default: \&quot;placidus\&quot;) | [optional] [default to 'placidus']
**language** | **str** | Language code for text content | [optional] [default to 'en']
**include_text** | **bool** | Include interpretation text | [optional] [default to True]
**include_readable_entities** | **bool** | Include human-readable entity titles | [optional] [default to False]
**points** | **List[str]** | Celestial points to calculate (e.g., [\&quot;sun\&quot;, \&quot;moon\&quot;, \&quot;mercury\&quot;]). Defaults to all major planets. | [optional] 
**orbs** | **Dict[str, float]** | Custom orb values per aspect type (e.g., { \&quot;conjunction\&quot;: 8, \&quot;opposition\&quot;: 6 }) | [optional] 

## Example

```python
from astroapi.models.composite_request import CompositeRequest

# TODO update the JSON string below
json = "{}"
# create an instance of CompositeRequest from a JSON string
composite_request_instance = CompositeRequest.from_json(json)
# print the JSON string representation of the object
print(CompositeRequest.to_json())

# convert the object into a dict
composite_request_dict = composite_request_instance.to_dict()
# create an instance of CompositeRequest from a dict
composite_request_from_dict = CompositeRequest.from_dict(composite_request_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


