# astroapi.ContentApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_content**](ContentApi.md#create_content) | **POST** /api/content/{horoscopeType}/{contentType} | Create Content
[**create_content_custom_copy**](ContentApi.md#create_content_custom_copy) | **POST** /api/content/{id}/create-custom-copy | Create Custom Copy
[**delete_content**](ContentApi.md#delete_content) | **DELETE** /api/content/{horoscopeType}/{contentType}/{id} | Delete Content
[**delete_content_by_id**](ContentApi.md#delete_content_by_id) | **DELETE** /api/content/{id} | Delete Content by ID
[**get_content**](ContentApi.md#get_content) | **GET** /api/content/{horoscopeType}/{contentType}/{id} | Get Content
[**list_content**](ContentApi.md#list_content) | **GET** /api/content/{horoscopeType}/{contentType} | List Content
[**restore_content**](ContentApi.md#restore_content) | **POST** /api/content/{id}/restore | Restore Content


# **create_content**
> ContentResponse create_content(horoscope_type, content_type)

Create Content

Create a new content item for a specific horoscope and content type.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.content_response import ContentResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ContentApi(api_client)
    horoscope_type = 'horoscope_type_example' # str | 
    content_type = 'content_type_example' # str | 

    try:
        # Create Content
        api_response = api_instance.create_content(horoscope_type, content_type)
        print("The response of ContentApi->create_content:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContentApi->create_content: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **horoscope_type** | **str**|  | 
 **content_type** | **str**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Create content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_content_custom_copy**
> ContentResponse create_content_custom_copy(id)

Create Custom Copy

Create an organization-specific copy of system content for customization.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.content_response import ContentResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ContentApi(api_client)
    id = 'id_example' # str | 

    try:
        # Create Custom Copy
        api_response = api_instance.create_content_custom_copy(id)
        print("The response of ContentApi->create_content_custom_copy:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContentApi->create_content_custom_copy: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Create a custom copy of system content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_content**
> delete_content(id, horoscope_type, content_type)

Delete Content

Delete a content item by horoscope type, content type, and ID.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ContentApi(api_client)
    id = 'id_example' # str | 
    horoscope_type = 'horoscope_type_example' # str | 
    content_type = 'content_type_example' # str | 

    try:
        # Delete Content
        api_instance.delete_content(id, horoscope_type, content_type)
    except Exception as e:
        print("Exception when calling ContentApi->delete_content: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **horoscope_type** | **str**|  | 
 **content_type** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete one content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_content_by_id**
> ContentResponse delete_content_by_id(id)

Delete Content by ID

Delete a content item by its ID.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.content_response import ContentResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ContentApi(api_client)
    id = 'id_example' # str | 

    try:
        # Delete Content by ID
        api_response = api_instance.delete_content_by_id(id)
        print("The response of ContentApi->delete_content_by_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContentApi->delete_content_by_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Delete one content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_content**
> ContentResponse get_content(id, horoscope_type, content_type)

Get Content

Retrieve a single content item by its ID.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.content_response import ContentResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ContentApi(api_client)
    id = 'id_example' # str | 
    horoscope_type = 'horoscope_type_example' # str | 
    content_type = 'content_type_example' # str | 

    try:
        # Get Content
        api_response = api_instance.get_content(id, horoscope_type, content_type)
        print("The response of ContentApi->get_content:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContentApi->get_content: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 
 **horoscope_type** | **str**|  | 
 **content_type** | **str**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Retrieve one content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **list_content**
> ContentResponse list_content(horoscope_type, content_type)

List Content

Retrieve a paginated list of content items filtered by horoscope and content type.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.content_response import ContentResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ContentApi(api_client)
    horoscope_type = 'horoscope_type_example' # str | 
    content_type = 'content_type_example' # str | 

    try:
        # List Content
        api_response = api_instance.list_content(horoscope_type, content_type)
        print("The response of ContentApi->list_content:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContentApi->list_content: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **horoscope_type** | **str**|  | 
 **content_type** | **str**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Retrieve content items |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **restore_content**
> ContentResponse restore_content(id)

Restore Content

Restore custom content to match the original system content.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.content_response import ContentResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ContentApi(api_client)
    id = 'id_example' # str | 

    try:
        # Restore Content
        api_response = api_instance.restore_content(id)
        print("The response of ContentApi->restore_content:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ContentApi->restore_content: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **str**|  | 

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Restore custom content to match system content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

