# astroapi.HoroscopeApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_daily_horoscopes**](HoroscopeApi.md#get_daily_horoscopes) | **GET** /api/horoscope/daily/{date} | Get Daily Horoscopes
[**get_weekly_horoscope**](HoroscopeApi.md#get_weekly_horoscope) | **GET** /api/horoscope/weekly/{year}/{week}/{zodiacSign} | Get Weekly Horoscope Report
[**get_yearly_ascendant_horoscope**](HoroscopeApi.md#get_yearly_ascendant_horoscope) | **GET** /api/horoscope/yearly-ascendant/{year}/{zodiacSign} | Get Yearly Ascendant Horoscope Report
[**get_yearly_horoscope**](HoroscopeApi.md#get_yearly_horoscope) | **GET** /api/horoscope/yearly/{year}/{zodiacSign} | Get Yearly Horoscope Report


# **get_daily_horoscopes**
> DailyHoroscopeResponse get_daily_horoscopes(var_date)

Get Daily Horoscopes

Retrieve daily horoscopes for all zodiac signs for a specific date.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.daily_horoscope_response import DailyHoroscopeResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.HoroscopeApi(api_client)
    var_date = 'var_date_example' # str | 

    try:
        # Get Daily Horoscopes
        api_response = api_instance.get_daily_horoscopes(var_date)
        print("The response of HoroscopeApi->get_daily_horoscopes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling HoroscopeApi->get_daily_horoscopes: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **var_date** | **str**|  | 

### Return type

[**DailyHoroscopeResponse**](DailyHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Daily horoscopes for all zodiac signs |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_weekly_horoscope**
> HoroscopeReportResponse get_weekly_horoscope(year, week, zodiac_sign)

Get Weekly Horoscope Report

Retrieve weekly horoscope report for a specific zodiac sign and week.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.horoscope_report_response import HoroscopeReportResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.HoroscopeApi(api_client)
    year = 'year_example' # str | 
    week = 'week_example' # str | 
    zodiac_sign = 'zodiac_sign_example' # str | 

    try:
        # Get Weekly Horoscope Report
        api_response = api_instance.get_weekly_horoscope(year, week, zodiac_sign)
        print("The response of HoroscopeApi->get_weekly_horoscope:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling HoroscopeApi->get_weekly_horoscope: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **year** | **str**|  | 
 **week** | **str**|  | 
 **zodiac_sign** | **str**|  | 

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Weekly horoscope report |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_yearly_ascendant_horoscope**
> HoroscopeReportResponse get_yearly_ascendant_horoscope(year, zodiac_sign)

Get Yearly Ascendant Horoscope Report

Retrieve yearly horoscope report for a specific ascendant sign and year.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.horoscope_report_response import HoroscopeReportResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.HoroscopeApi(api_client)
    year = 'year_example' # str | 
    zodiac_sign = 'zodiac_sign_example' # str | 

    try:
        # Get Yearly Ascendant Horoscope Report
        api_response = api_instance.get_yearly_ascendant_horoscope(year, zodiac_sign)
        print("The response of HoroscopeApi->get_yearly_ascendant_horoscope:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling HoroscopeApi->get_yearly_ascendant_horoscope: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **year** | **str**|  | 
 **zodiac_sign** | **str**|  | 

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Yearly ascendant horoscope report |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_yearly_horoscope**
> HoroscopeReportResponse get_yearly_horoscope(year, zodiac_sign)

Get Yearly Horoscope Report

Retrieve yearly horoscope report for a specific zodiac sign and year.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.horoscope_report_response import HoroscopeReportResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.HoroscopeApi(api_client)
    year = 'year_example' # str | 
    zodiac_sign = 'zodiac_sign_example' # str | 

    try:
        # Get Yearly Horoscope Report
        api_response = api_instance.get_yearly_horoscope(year, zodiac_sign)
        print("The response of HoroscopeApi->get_yearly_horoscope:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling HoroscopeApi->get_yearly_horoscope: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **year** | **str**|  | 
 **zodiac_sign** | **str**|  | 

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Yearly horoscope report |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

