# astroapi.ModulesApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_api_modules**](ModulesApi.md#get_api_modules) | **GET** /api/modules | List Modules
[**get_api_modules_check_module_id**](ModulesApi.md#get_api_modules_check_module_id) | **GET** /api/modules/check/{moduleId} | Check Module Access
[**get_api_modules_organization**](ModulesApi.md#get_api_modules_organization) | **GET** /api/modules/organization | Organization Modules
[**get_api_modules_plans**](ModulesApi.md#get_api_modules_plans) | **GET** /api/modules/plans | Subscription Plans


# **get_api_modules**
> GetApiModules200Response get_api_modules()

List Modules

Get all available modules with pricing information.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.get_api_modules200_response import GetApiModules200Response
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ModulesApi(api_client)

    try:
        # List Modules
        api_response = api_instance.get_api_modules()
        print("The response of ModulesApi->get_api_modules:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ModulesApi->get_api_modules: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModules200Response**](GetApiModules200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List all available modules |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_api_modules_check_module_id**
> ModuleAccessCheck get_api_modules_check_module_id(module_id)

Check Module Access

Check if the current organization has access to a specific module.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.module_access_check import ModuleAccessCheck
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ModulesApi(api_client)
    module_id = 'module_id_example' # str | 

    try:
        # Check Module Access
        api_response = api_instance.get_api_modules_check_module_id(module_id)
        print("The response of ModulesApi->get_api_modules_check_module_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ModulesApi->get_api_modules_check_module_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **module_id** | **str**|  | 

### Return type

[**ModuleAccessCheck**](ModuleAccessCheck.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Check module access |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_api_modules_organization**
> GetApiModulesOrganization200Response get_api_modules_organization()

Organization Modules

Get the list of modules the current organization has access to.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.get_api_modules_organization200_response import GetApiModulesOrganization200Response
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ModulesApi(api_client)

    try:
        # Organization Modules
        api_response = api_instance.get_api_modules_organization()
        print("The response of ModulesApi->get_api_modules_organization:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ModulesApi->get_api_modules_organization: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModulesOrganization200Response**](GetApiModulesOrganization200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List modules for current organization |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_api_modules_plans**
> GetApiModulesPlans200Response get_api_modules_plans()

Subscription Plans

Get all available subscription plans with included modules and pricing.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.get_api_modules_plans200_response import GetApiModulesPlans200Response
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.ModulesApi(api_client)

    try:
        # Subscription Plans
        api_response = api_instance.get_api_modules_plans()
        print("The response of ModulesApi->get_api_modules_plans:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling ModulesApi->get_api_modules_plans: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModulesPlans200Response**](GetApiModulesPlans200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List all subscription plans |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

