# astroapi.NumerologyApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**post_api_numerology_birthday**](NumerologyApi.md#post_api_numerology_birthday) | **POST** /api/numerology/birthday | Birthday Number
[**post_api_numerology_compatibility**](NumerologyApi.md#post_api_numerology_compatibility) | **POST** /api/numerology/compatibility | Numerology Compatibility
[**post_api_numerology_expression**](NumerologyApi.md#post_api_numerology_expression) | **POST** /api/numerology/expression | Expression Number
[**post_api_numerology_life_path**](NumerologyApi.md#post_api_numerology_life_path) | **POST** /api/numerology/life-path | Life Path Number
[**post_api_numerology_personal_cycles**](NumerologyApi.md#post_api_numerology_personal_cycles) | **POST** /api/numerology/personal-cycles | Personal Cycles
[**post_api_numerology_personality**](NumerologyApi.md#post_api_numerology_personality) | **POST** /api/numerology/personality | Personality Number
[**post_api_numerology_profile**](NumerologyApi.md#post_api_numerology_profile) | **POST** /api/numerology/profile | Full Numerology Profile
[**post_api_numerology_soul_urge**](NumerologyApi.md#post_api_numerology_soul_urge) | **POST** /api/numerology/soul-urge | Soul Urge Number


# **post_api_numerology_birthday**
> NumerologyBirthdayResponse post_api_numerology_birthday(numerology_birthday_request=numerology_birthday_request)

Birthday Number

Calculate the Birthday Number from the day of birth. This number represents a special talent you possess.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_birthday_request import NumerologyBirthdayRequest
from astroapi.models.numerology_birthday_response import NumerologyBirthdayResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_birthday_request = astroapi.NumerologyBirthdayRequest() # NumerologyBirthdayRequest |  (optional)

    try:
        # Birthday Number
        api_response = api_instance.post_api_numerology_birthday(numerology_birthday_request=numerology_birthday_request)
        print("The response of NumerologyApi->post_api_numerology_birthday:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_birthday: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_birthday_request** | [**NumerologyBirthdayRequest**](NumerologyBirthdayRequest.md)|  | [optional] 

### Return type

[**NumerologyBirthdayResponse**](NumerologyBirthdayResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Birthday number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_numerology_compatibility**
> NumerologyCompatibilityResponse post_api_numerology_compatibility(numerology_compatibility_request=numerology_compatibility_request)

Numerology Compatibility

Calculate compatibility between two people based on their Life Path numbers.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_compatibility_request import NumerologyCompatibilityRequest
from astroapi.models.numerology_compatibility_response import NumerologyCompatibilityResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_compatibility_request = astroapi.NumerologyCompatibilityRequest() # NumerologyCompatibilityRequest |  (optional)

    try:
        # Numerology Compatibility
        api_response = api_instance.post_api_numerology_compatibility(numerology_compatibility_request=numerology_compatibility_request)
        print("The response of NumerologyApi->post_api_numerology_compatibility:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_compatibility: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_compatibility_request** | [**NumerologyCompatibilityRequest**](NumerologyCompatibilityRequest.md)|  | [optional] 

### Return type

[**NumerologyCompatibilityResponse**](NumerologyCompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Compatibility calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_numerology_expression**
> NumerologyExpressionResponse post_api_numerology_expression(numerology_expression_request=numerology_expression_request)

Expression Number

Calculate the Expression (Destiny) Number from full name. This number reveals your natural talents and abilities.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_expression_request import NumerologyExpressionRequest
from astroapi.models.numerology_expression_response import NumerologyExpressionResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_expression_request = astroapi.NumerologyExpressionRequest() # NumerologyExpressionRequest |  (optional)

    try:
        # Expression Number
        api_response = api_instance.post_api_numerology_expression(numerology_expression_request=numerology_expression_request)
        print("The response of NumerologyApi->post_api_numerology_expression:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_expression: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_expression_request** | [**NumerologyExpressionRequest**](NumerologyExpressionRequest.md)|  | [optional] 

### Return type

[**NumerologyExpressionResponse**](NumerologyExpressionResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Expression number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_numerology_life_path**
> NumerologyLifePathResponse post_api_numerology_life_path(numerology_life_path_request=numerology_life_path_request)

Life Path Number

Calculate the Life Path Number from birth date. This is the most important number in numerology, representing your life's purpose.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_life_path_request import NumerologyLifePathRequest
from astroapi.models.numerology_life_path_response import NumerologyLifePathResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_life_path_request = astroapi.NumerologyLifePathRequest() # NumerologyLifePathRequest |  (optional)

    try:
        # Life Path Number
        api_response = api_instance.post_api_numerology_life_path(numerology_life_path_request=numerology_life_path_request)
        print("The response of NumerologyApi->post_api_numerology_life_path:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_life_path: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_life_path_request** | [**NumerologyLifePathRequest**](NumerologyLifePathRequest.md)|  | [optional] 

### Return type

[**NumerologyLifePathResponse**](NumerologyLifePathResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Life Path number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_numerology_personal_cycles**
> NumerologyPersonalCyclesResponse post_api_numerology_personal_cycles(numerology_personal_cycles_request=numerology_personal_cycles_request)

Personal Cycles

Calculate Personal Year, Month, and Day numbers. These reveal the current energetic influences in your life.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_personal_cycles_request import NumerologyPersonalCyclesRequest
from astroapi.models.numerology_personal_cycles_response import NumerologyPersonalCyclesResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_personal_cycles_request = astroapi.NumerologyPersonalCyclesRequest() # NumerologyPersonalCyclesRequest |  (optional)

    try:
        # Personal Cycles
        api_response = api_instance.post_api_numerology_personal_cycles(numerology_personal_cycles_request=numerology_personal_cycles_request)
        print("The response of NumerologyApi->post_api_numerology_personal_cycles:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_personal_cycles: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_personal_cycles_request** | [**NumerologyPersonalCyclesRequest**](NumerologyPersonalCyclesRequest.md)|  | [optional] 

### Return type

[**NumerologyPersonalCyclesResponse**](NumerologyPersonalCyclesResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Personal cycles calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_numerology_personality**
> NumerologyPersonalityResponse post_api_numerology_personality(numerology_personality_request=numerology_personality_request)

Personality Number

Calculate the Personality Number from consonants in the name. This number reveals how others perceive you.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_personality_request import NumerologyPersonalityRequest
from astroapi.models.numerology_personality_response import NumerologyPersonalityResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_personality_request = astroapi.NumerologyPersonalityRequest() # NumerologyPersonalityRequest |  (optional)

    try:
        # Personality Number
        api_response = api_instance.post_api_numerology_personality(numerology_personality_request=numerology_personality_request)
        print("The response of NumerologyApi->post_api_numerology_personality:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_personality: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_personality_request** | [**NumerologyPersonalityRequest**](NumerologyPersonalityRequest.md)|  | [optional] 

### Return type

[**NumerologyPersonalityResponse**](NumerologyPersonalityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Personality number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_numerology_profile**
> NumerologyProfileResponse post_api_numerology_profile(numerology_profile_request=numerology_profile_request)

Full Numerology Profile

Calculate a complete numerology profile including Life Path, Expression, Soul Urge, Personality, Birthday numbers, Personal Cycles, and identify Master/Karmic numbers.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_profile_request import NumerologyProfileRequest
from astroapi.models.numerology_profile_response import NumerologyProfileResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_profile_request = astroapi.NumerologyProfileRequest() # NumerologyProfileRequest |  (optional)

    try:
        # Full Numerology Profile
        api_response = api_instance.post_api_numerology_profile(numerology_profile_request=numerology_profile_request)
        print("The response of NumerologyApi->post_api_numerology_profile:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_profile: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_profile_request** | [**NumerologyProfileRequest**](NumerologyProfileRequest.md)|  | [optional] 

### Return type

[**NumerologyProfileResponse**](NumerologyProfileResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Complete numerology profile |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_numerology_soul_urge**
> NumerologySoulUrgeResponse post_api_numerology_soul_urge(numerology_soul_urge_request=numerology_soul_urge_request)

Soul Urge Number

Calculate the Soul Urge (Heart's Desire) Number from vowels in the name. This number reveals your inner motivations.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.numerology_soul_urge_request import NumerologySoulUrgeRequest
from astroapi.models.numerology_soul_urge_response import NumerologySoulUrgeResponse
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.NumerologyApi(api_client)
    numerology_soul_urge_request = astroapi.NumerologySoulUrgeRequest() # NumerologySoulUrgeRequest |  (optional)

    try:
        # Soul Urge Number
        api_response = api_instance.post_api_numerology_soul_urge(numerology_soul_urge_request=numerology_soul_urge_request)
        print("The response of NumerologyApi->post_api_numerology_soul_urge:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NumerologyApi->post_api_numerology_soul_urge: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **numerology_soul_urge_request** | [**NumerologySoulUrgeRequest**](NumerologySoulUrgeRequest.md)|  | [optional] 

### Return type

[**NumerologySoulUrgeResponse**](NumerologySoulUrgeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Soul Urge number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

