# astroapi.OrganizationsApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**delete_api_org_users_member_id**](OrganizationsApi.md#delete_api_org_users_member_id) | **DELETE** /api/org/users/{memberId} | Remove Member
[**get_api_org_users**](OrganizationsApi.md#get_api_org_users) | **GET** /api/org/users | List Members
[**patch_api_org_users_member_id**](OrganizationsApi.md#patch_api_org_users_member_id) | **PATCH** /api/org/users/{memberId} | Update Member
[**post_api_org**](OrganizationsApi.md#post_api_org) | **POST** /api/org | Create Organization
[**post_api_org_users**](OrganizationsApi.md#post_api_org_users) | **POST** /api/org/users | Add Member


# **delete_api_org_users_member_id**
> delete_api_org_users_member_id(member_id)

Remove Member

Remove a member from the organization.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.OrganizationsApi(api_client)
    member_id = 'member_id_example' # str | 

    try:
        # Remove Member
        api_instance.delete_api_org_users_member_id(member_id)
    except Exception as e:
        print("Exception when calling OrganizationsApi->delete_api_org_users_member_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **member_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | Member verwijderd |  -  |
**400** | Invalid request |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |
**404** | Member not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_api_org_users**
> GetApiOrgUsers200Response get_api_org_users()

List Members

Get a paginated list of organization members.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.get_api_org_users200_response import GetApiOrgUsers200Response
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.OrganizationsApi(api_client)

    try:
        # List Members
        api_response = api_instance.get_api_org_users()
        print("The response of OrganizationsApi->get_api_org_users:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling OrganizationsApi->get_api_org_users: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiOrgUsers200Response**](GetApiOrgUsers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List organization users |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **patch_api_org_users_member_id**
> PatchApiOrgUsersMemberId200Response patch_api_org_users_member_id(member_id, patch_api_org_users_member_id_request=patch_api_org_users_member_id_request)

Update Member

Update an organization member's role.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.patch_api_org_users_member_id200_response import PatchApiOrgUsersMemberId200Response
from astroapi.models.patch_api_org_users_member_id_request import PatchApiOrgUsersMemberIdRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.OrganizationsApi(api_client)
    member_id = 'member_id_example' # str | 
    patch_api_org_users_member_id_request = astroapi.PatchApiOrgUsersMemberIdRequest() # PatchApiOrgUsersMemberIdRequest |  (optional)

    try:
        # Update Member
        api_response = api_instance.patch_api_org_users_member_id(member_id, patch_api_org_users_member_id_request=patch_api_org_users_member_id_request)
        print("The response of OrganizationsApi->patch_api_org_users_member_id:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling OrganizationsApi->patch_api_org_users_member_id: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **member_id** | **str**|  | 
 **patch_api_org_users_member_id_request** | [**PatchApiOrgUsersMemberIdRequest**](PatchApiOrgUsersMemberIdRequest.md)|  | [optional] 

### Return type

[**PatchApiOrgUsersMemberId200Response**](PatchApiOrgUsersMemberId200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Member geüpdatet |  -  |
**400** | Invalid request |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |
**404** | Member not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_org**
> object post_api_org()

Create Organization

Create a new organization with Stripe billing setup.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.OrganizationsApi(api_client)

    try:
        # Create Organization
        api_response = api_instance.post_api_org()
        print("The response of OrganizationsApi->post_api_org:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling OrganizationsApi->post_api_org: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Create organization |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post_api_org_users**
> PostApiOrgUsers201Response post_api_org_users(post_api_org_users_request=post_api_org_users_request)

Add Member

Add or invite a new member to the organization.

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.post_api_org_users201_response import PostApiOrgUsers201Response
from astroapi.models.post_api_org_users_request import PostApiOrgUsersRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.OrganizationsApi(api_client)
    post_api_org_users_request = astroapi.PostApiOrgUsersRequest() # PostApiOrgUsersRequest |  (optional)

    try:
        # Add Member
        api_response = api_instance.post_api_org_users(post_api_org_users_request=post_api_org_users_request)
        print("The response of OrganizationsApi->post_api_org_users:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling OrganizationsApi->post_api_org_users: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **post_api_org_users_request** | [**PostApiOrgUsersRequest**](PostApiOrgUsersRequest.md)|  | [optional] 

### Return type

[**PostApiOrgUsers201Response**](PostApiOrgUsers201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/vnd.api+json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Member toegevoegd/uitgenodigd |  -  |
**400** | Invalid request |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

