# TransitRequest


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**birth_date** | **str** | Birth date and time in YYYY-MM-DDTHH:mm format | 
**birth_location** | [**Location**](Location.md) |  | 
**transit_date_start** | **str** | Transit period start date in YYYY-MM-DDTHH:mm format | 
**transit_date_end** | **str** | Transit period end date in YYYY-MM-DDTHH:mm format | 
**transit_location** | [**Location**](Location.md) |  | 
**house_system** | **str** | House system for calculations (default: \&quot;placidus\&quot;) | [optional] [default to 'placidus']
**language** | **str** | Language code for text content | [optional] [default to 'en']
**include_text** | **bool** | Include interpretation text | [optional] [default to True]
**include_readable_entities** | **bool** | Include human-readable entity titles | [optional] [default to False]
**points** | **List[str]** | Celestial points to calculate (e.g., [\&quot;sun\&quot;, \&quot;moon\&quot;, \&quot;mercury\&quot;]). Defaults to all major planets. | [optional] 
**orbs** | **Dict[str, float]** | Custom orb values per aspect type (e.g., { \&quot;conjunction\&quot;: 8, \&quot;opposition\&quot;: 6 }) | [optional] 

## Example

```python
from astroapi.models.transit_request import TransitRequest

# TODO update the JSON string below
json = "{}"
# create an instance of TransitRequest from a JSON string
transit_request_instance = TransitRequest.from_json(json)
# print the JSON string representation of the object
print(TransitRequest.to_json())

# convert the object into a dict
transit_request_dict = transit_request_instance.to_dict()
# create an instance of TransitRequest from a dict
transit_request_from_dict = TransitRequest.from_dict(transit_request_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


