# astroapi.WidgetApi

All URIs are relative to *https://api.astroapi.cloud*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_widget_config**](WidgetApi.md#get_widget_config) | **GET** /widget/config/{chatbotId} | Get Widget Configuration
[**widget_chat**](WidgetApi.md#widget_chat) | **POST** /widget/chat/{chatbotId} | Widget Chat
[**widget_chat_with_user**](WidgetApi.md#widget_chat_with_user) | **POST** /widget/chat/{chatbotId}/user/{externalUserId} | Widget Chat with User Profile


# **get_widget_config**
> get_widget_config(chatbot_id)

Get Widget Configuration

Get the widget configuration for embedding

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.WidgetApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 

    try:
        # Get Widget Configuration
        api_instance.get_widget_config(chatbot_id)
    except Exception as e:
        print("Exception when calling WidgetApi->get_widget_config: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Widget configuration |  -  |
**404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **widget_chat**
> object widget_chat(chatbot_id, widget_chat_request=widget_chat_request)

Widget Chat

Send a message via widget (SSE streaming response)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.widget_chat_request import WidgetChatRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.WidgetApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 
    widget_chat_request = astroapi.WidgetChatRequest() # WidgetChatRequest |  (optional)

    try:
        # Widget Chat
        api_response = api_instance.widget_chat(chatbot_id, widget_chat_request=widget_chat_request)
        print("The response of WidgetApi->widget_chat:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WidgetApi->widget_chat: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 
 **widget_chat_request** | [**WidgetChatRequest**](WidgetChatRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: text/event-stream

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SSE stream with chat response |  -  |
**401** | API key required |  -  |
**403** | Domain not allowed |  -  |
**404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **widget_chat_with_user**
> object widget_chat_with_user(chatbot_id, external_user_id, widget_chat_with_user_request=widget_chat_with_user_request)

Widget Chat with User Profile

Chat using an external user ID (creates profile on first use)

### Example

* Api Key Authentication (ApiKeyAuth):

```python
import astroapi
from astroapi.models.widget_chat_with_user_request import WidgetChatWithUserRequest
from astroapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.astroapi.cloud
# See configuration.py for a list of all supported configuration parameters.
configuration = astroapi.Configuration(
    host = "https://api.astroapi.cloud"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'

# Enter a context with an instance of the API client
with astroapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = astroapi.WidgetApi(api_client)
    chatbot_id = 'chatbot_id_example' # str | 
    external_user_id = 'external_user_id_example' # str | 
    widget_chat_with_user_request = astroapi.WidgetChatWithUserRequest() # WidgetChatWithUserRequest |  (optional)

    try:
        # Widget Chat with User Profile
        api_response = api_instance.widget_chat_with_user(chatbot_id, external_user_id, widget_chat_with_user_request=widget_chat_with_user_request)
        print("The response of WidgetApi->widget_chat_with_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling WidgetApi->widget_chat_with_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatbot_id** | **str**|  | 
 **external_user_id** | **str**|  | 
 **widget_chat_with_user_request** | [**WidgetChatWithUserRequest**](WidgetChatWithUserRequest.md)|  | [optional] 

### Return type

**object**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: text/event-stream

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | SSE stream with chat response |  -  |
**400** | Birth data required for new users |  -  |
**401** | API key required |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

