/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApiKeyOptions,
  CreateApiKeyRequest,
  GetApiApiKeys200Response,
  GetApiKey200Response,
  PostApiApiKeys201Response,
  UpdateApiKeyRequest,
} from '../models/index';
import {
    ApiKeyOptionsFromJSON,
    ApiKeyOptionsToJSON,
    CreateApiKeyRequestFromJSON,
    CreateApiKeyRequestToJSON,
    GetApiApiKeys200ResponseFromJSON,
    GetApiApiKeys200ResponseToJSON,
    GetApiKey200ResponseFromJSON,
    GetApiKey200ResponseToJSON,
    PostApiApiKeys201ResponseFromJSON,
    PostApiApiKeys201ResponseToJSON,
    UpdateApiKeyRequestFromJSON,
    UpdateApiKeyRequestToJSON,
} from '../models/index';

export interface DeleteApiKeyRequest {
    id: string;
}

export interface GetApiKeyRequest {
    id: string;
}

export interface PostApiApiKeysRequest {
    createApiKeyRequest?: CreateApiKeyRequest;
}

export interface UpdateApiKeyOperationRequest {
    id: string;
    updateApiKeyRequest?: UpdateApiKeyRequest;
}

/**
 * APIKeysApi - interface
 * 
 * @export
 * @interface APIKeysApiInterface
 */
export interface APIKeysApiInterface {
    /**
     * Permanently delete an API key.
     * @summary Delete API Key
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof APIKeysApiInterface
     */
    deleteApiKeyRaw(requestParameters: DeleteApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Permanently delete an API key.
     * Delete API Key
     */
    deleteApiKey(requestParameters: DeleteApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Get all API keys owned by the current user.
     * @summary List API Keys
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof APIKeysApiInterface
     */
    getApiApiKeysRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiApiKeys200Response>>;

    /**
     * Get all API keys owned by the current user.
     * List API Keys
     */
    getApiApiKeys(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiApiKeys200Response>;

    /**
     * Get available permissions and modules for configuring API keys.
     * @summary Available Options
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof APIKeysApiInterface
     */
    getApiApiKeysAvailableOptionsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ApiKeyOptions>>;

    /**
     * Get available permissions and modules for configuring API keys.
     * Available Options
     */
    getApiApiKeysAvailableOptions(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ApiKeyOptions>;

    /**
     * Get details of a specific API key.
     * @summary Get API Key
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof APIKeysApiInterface
     */
    getApiKeyRaw(requestParameters: GetApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiKey200Response>>;

    /**
     * Get details of a specific API key.
     * Get API Key
     */
    getApiKey(requestParameters: GetApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiKey200Response>;

    /**
     * Create a new API key with optional permission and module restrictions.
     * @summary Create API Key
     * @param {CreateApiKeyRequest} [createApiKeyRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof APIKeysApiInterface
     */
    postApiApiKeysRaw(requestParameters: PostApiApiKeysRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PostApiApiKeys201Response>>;

    /**
     * Create a new API key with optional permission and module restrictions.
     * Create API Key
     */
    postApiApiKeys(requestParameters: PostApiApiKeysRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PostApiApiKeys201Response>;

    /**
     * Update an API key\'s name, status, permissions, or modules.
     * @summary Update API Key
     * @param {string} id 
     * @param {UpdateApiKeyRequest} [updateApiKeyRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof APIKeysApiInterface
     */
    updateApiKeyRaw(requestParameters: UpdateApiKeyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiKey200Response>>;

    /**
     * Update an API key\'s name, status, permissions, or modules.
     * Update API Key
     */
    updateApiKey(requestParameters: UpdateApiKeyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiKey200Response>;

}

/**
 * 
 */
export class APIKeysApi extends runtime.BaseAPI implements APIKeysApiInterface {

    /**
     * Permanently delete an API key.
     * Delete API Key
     */
    async deleteApiKeyRaw(requestParameters: DeleteApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling deleteApiKey().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/api-keys/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Permanently delete an API key.
     * Delete API Key
     */
    async deleteApiKey(requestParameters: DeleteApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteApiKeyRaw(requestParameters, initOverrides);
    }

    /**
     * Get all API keys owned by the current user.
     * List API Keys
     */
    async getApiApiKeysRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiApiKeys200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/api-keys`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetApiApiKeys200ResponseFromJSON(jsonValue));
    }

    /**
     * Get all API keys owned by the current user.
     * List API Keys
     */
    async getApiApiKeys(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiApiKeys200Response> {
        const response = await this.getApiApiKeysRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get available permissions and modules for configuring API keys.
     * Available Options
     */
    async getApiApiKeysAvailableOptionsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ApiKeyOptions>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/api-keys/available-options`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ApiKeyOptionsFromJSON(jsonValue));
    }

    /**
     * Get available permissions and modules for configuring API keys.
     * Available Options
     */
    async getApiApiKeysAvailableOptions(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ApiKeyOptions> {
        const response = await this.getApiApiKeysAvailableOptionsRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get details of a specific API key.
     * Get API Key
     */
    async getApiKeyRaw(requestParameters: GetApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiKey200Response>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling getApiKey().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/api-keys/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetApiKey200ResponseFromJSON(jsonValue));
    }

    /**
     * Get details of a specific API key.
     * Get API Key
     */
    async getApiKey(requestParameters: GetApiKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiKey200Response> {
        const response = await this.getApiKeyRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create a new API key with optional permission and module restrictions.
     * Create API Key
     */
    async postApiApiKeysRaw(requestParameters: PostApiApiKeysRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PostApiApiKeys201Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/api-keys`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CreateApiKeyRequestToJSON(requestParameters['createApiKeyRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PostApiApiKeys201ResponseFromJSON(jsonValue));
    }

    /**
     * Create a new API key with optional permission and module restrictions.
     * Create API Key
     */
    async postApiApiKeys(requestParameters: PostApiApiKeysRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PostApiApiKeys201Response> {
        const response = await this.postApiApiKeysRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Update an API key\'s name, status, permissions, or modules.
     * Update API Key
     */
    async updateApiKeyRaw(requestParameters: UpdateApiKeyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiKey200Response>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling updateApiKey().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/api-keys/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: UpdateApiKeyRequestToJSON(requestParameters['updateApiKeyRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetApiKey200ResponseFromJSON(jsonValue));
    }

    /**
     * Update an API key\'s name, status, permissions, or modules.
     * Update API Key
     */
    async updateApiKey(requestParameters: UpdateApiKeyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiKey200Response> {
        const response = await this.updateApiKeyRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
