/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ChineseForecastRequest,
  ChineseForecastResponse,
  ChineseHoroscopeRequest,
  ChineseHoroscopeResponse,
  CompatibilityRequest,
  CompatibilityResponse,
  CompositeRequest,
  CompositeResponse,
  LunarReturnRequest,
  LunarReturnResponse,
  MoonSunRequest,
  MoonSunResponse,
  NatalRequest,
  NatalResponse,
  ProgressionsRequest,
  ProgressionsResponse,
  SolarReturnRequest,
  SolarReturnResponse,
  SynastryRequest,
  SynastryResponse,
  TransitRequest,
  TransitResponse,
} from '../models/index';
import {
    ChineseForecastRequestFromJSON,
    ChineseForecastRequestToJSON,
    ChineseForecastResponseFromJSON,
    ChineseForecastResponseToJSON,
    ChineseHoroscopeRequestFromJSON,
    ChineseHoroscopeRequestToJSON,
    ChineseHoroscopeResponseFromJSON,
    ChineseHoroscopeResponseToJSON,
    CompatibilityRequestFromJSON,
    CompatibilityRequestToJSON,
    CompatibilityResponseFromJSON,
    CompatibilityResponseToJSON,
    CompositeRequestFromJSON,
    CompositeRequestToJSON,
    CompositeResponseFromJSON,
    CompositeResponseToJSON,
    LunarReturnRequestFromJSON,
    LunarReturnRequestToJSON,
    LunarReturnResponseFromJSON,
    LunarReturnResponseToJSON,
    MoonSunRequestFromJSON,
    MoonSunRequestToJSON,
    MoonSunResponseFromJSON,
    MoonSunResponseToJSON,
    NatalRequestFromJSON,
    NatalRequestToJSON,
    NatalResponseFromJSON,
    NatalResponseToJSON,
    ProgressionsRequestFromJSON,
    ProgressionsRequestToJSON,
    ProgressionsResponseFromJSON,
    ProgressionsResponseToJSON,
    SolarReturnRequestFromJSON,
    SolarReturnRequestToJSON,
    SolarReturnResponseFromJSON,
    SolarReturnResponseToJSON,
    SynastryRequestFromJSON,
    SynastryRequestToJSON,
    SynastryResponseFromJSON,
    SynastryResponseToJSON,
    TransitRequestFromJSON,
    TransitRequestToJSON,
    TransitResponseFromJSON,
    TransitResponseToJSON,
} from '../models/index';

export interface PostApiCalcChineseForecastRequest {
    chineseForecastRequest?: ChineseForecastRequest;
}

export interface PostApiCalcChineseHoroscopeRequest {
    chineseHoroscopeRequest?: ChineseHoroscopeRequest;
}

export interface PostApiCalcCompatibilityRequest {
    compatibilityRequest?: CompatibilityRequest;
}

export interface PostApiCalcCompositeRequest {
    compositeRequest?: CompositeRequest;
}

export interface PostApiCalcLunarReturnRequest {
    lunarReturnRequest?: LunarReturnRequest;
}

export interface PostApiCalcMoonSunRequest {
    moonSunRequest?: MoonSunRequest;
}

export interface PostApiCalcNatalRequest {
    natalRequest?: NatalRequest;
}

export interface PostApiCalcProgressionsRequest {
    progressionsRequest?: ProgressionsRequest;
}

export interface PostApiCalcSolarReturnRequest {
    solarReturnRequest?: SolarReturnRequest;
}

export interface PostApiCalcSynastryRequest {
    synastryRequest?: SynastryRequest;
}

export interface PostApiCalcTransitRequest {
    transitRequest?: TransitRequest;
}

/**
 * CalculationsApi - interface
 * 
 * @export
 * @interface CalculationsApiInterface
 */
export interface CalculationsApiInterface {
    /**
     * Get Chinese zodiac forecast for a specific year with category breakdowns.
     * @summary Chinese Zodiac Forecast
     * @param {ChineseForecastRequest} [chineseForecastRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcChineseForecastRaw(requestParameters: PostApiCalcChineseForecastRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ChineseForecastResponse>>;

    /**
     * Get Chinese zodiac forecast for a specific year with category breakdowns.
     * Chinese Zodiac Forecast
     */
    postApiCalcChineseForecast(requestParameters: PostApiCalcChineseForecastRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ChineseForecastResponse>;

    /**
     * Calculate the Chinese zodiac sign and element based on birth year.
     * @summary Chinese Zodiac Sign
     * @param {ChineseHoroscopeRequest} [chineseHoroscopeRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcChineseHoroscopeRaw(requestParameters: PostApiCalcChineseHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ChineseHoroscopeResponse>>;

    /**
     * Calculate the Chinese zodiac sign and element based on birth year.
     * Chinese Zodiac Sign
     */
    postApiCalcChineseHoroscope(requestParameters: PostApiCalcChineseHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ChineseHoroscopeResponse>;

    /**
     * Calculate sun sign compatibility between two people with interpretation text.
     * @summary Compatibility Analysis
     * @param {CompatibilityRequest} [compatibilityRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcCompatibilityRaw(requestParameters: PostApiCalcCompatibilityRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CompatibilityResponse>>;

    /**
     * Calculate sun sign compatibility between two people with interpretation text.
     * Compatibility Analysis
     */
    postApiCalcCompatibility(requestParameters: PostApiCalcCompatibilityRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CompatibilityResponse>;

    /**
     * Calculate a composite chart by combining midpoints of two birth charts.
     * @summary Composite Chart
     * @param {CompositeRequest} [compositeRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcCompositeRaw(requestParameters: PostApiCalcCompositeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CompositeResponse>>;

    /**
     * Calculate a composite chart by combining midpoints of two birth charts.
     * Composite Chart
     */
    postApiCalcComposite(requestParameters: PostApiCalcCompositeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CompositeResponse>;

    /**
     * Calculate the lunar return chart when the Moon returns to its natal position.
     * @summary Lunar Return
     * @param {LunarReturnRequest} [lunarReturnRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcLunarReturnRaw(requestParameters: PostApiCalcLunarReturnRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LunarReturnResponse>>;

    /**
     * Calculate the lunar return chart when the Moon returns to its natal position.
     * Lunar Return
     */
    postApiCalcLunarReturn(requestParameters: PostApiCalcLunarReturnRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LunarReturnResponse>;

    /**
     * Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.
     * @summary Moon & Sun Info
     * @param {MoonSunRequest} [moonSunRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcMoonSunRaw(requestParameters: PostApiCalcMoonSunRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<MoonSunResponse>>;

    /**
     * Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.
     * Moon & Sun Info
     */
    postApiCalcMoonSun(requestParameters: PostApiCalcMoonSunRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<MoonSunResponse>;

    /**
     * Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.
     * @summary Natal Chart
     * @param {NatalRequest} [natalRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcNatalRaw(requestParameters: PostApiCalcNatalRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NatalResponse>>;

    /**
     * Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.
     * Natal Chart
     */
    postApiCalcNatal(requestParameters: PostApiCalcNatalRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NatalResponse>;

    /**
     * Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.
     * @summary Secondary Progressions
     * @param {ProgressionsRequest} [progressionsRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcProgressionsRaw(requestParameters: PostApiCalcProgressionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ProgressionsResponse>>;

    /**
     * Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.
     * Secondary Progressions
     */
    postApiCalcProgressions(requestParameters: PostApiCalcProgressionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ProgressionsResponse>;

    /**
     * Calculate the solar return chart for a specific year (birthday chart).
     * @summary Solar Return
     * @param {SolarReturnRequest} [solarReturnRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcSolarReturnRaw(requestParameters: PostApiCalcSolarReturnRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SolarReturnResponse>>;

    /**
     * Calculate the solar return chart for a specific year (birthday chart).
     * Solar Return
     */
    postApiCalcSolarReturn(requestParameters: PostApiCalcSolarReturnRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SolarReturnResponse>;

    /**
     * Calculate synastry aspects between two birth charts for relationship analysis.
     * @summary Synastry Chart
     * @param {SynastryRequest} [synastryRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcSynastryRaw(requestParameters: PostApiCalcSynastryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SynastryResponse>>;

    /**
     * Calculate synastry aspects between two birth charts for relationship analysis.
     * Synastry Chart
     */
    postApiCalcSynastry(requestParameters: PostApiCalcSynastryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SynastryResponse>;

    /**
     * Calculate planetary transits over a natal chart for a specified time period.
     * @summary Transit Chart
     * @param {TransitRequest} [transitRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CalculationsApiInterface
     */
    postApiCalcTransitRaw(requestParameters: PostApiCalcTransitRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TransitResponse>>;

    /**
     * Calculate planetary transits over a natal chart for a specified time period.
     * Transit Chart
     */
    postApiCalcTransit(requestParameters: PostApiCalcTransitRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TransitResponse>;

}

/**
 * 
 */
export class CalculationsApi extends runtime.BaseAPI implements CalculationsApiInterface {

    /**
     * Get Chinese zodiac forecast for a specific year with category breakdowns.
     * Chinese Zodiac Forecast
     */
    async postApiCalcChineseForecastRaw(requestParameters: PostApiCalcChineseForecastRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ChineseForecastResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/chinese-forecast`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ChineseForecastRequestToJSON(requestParameters['chineseForecastRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ChineseForecastResponseFromJSON(jsonValue));
    }

    /**
     * Get Chinese zodiac forecast for a specific year with category breakdowns.
     * Chinese Zodiac Forecast
     */
    async postApiCalcChineseForecast(requestParameters: PostApiCalcChineseForecastRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ChineseForecastResponse> {
        const response = await this.postApiCalcChineseForecastRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate the Chinese zodiac sign and element based on birth year.
     * Chinese Zodiac Sign
     */
    async postApiCalcChineseHoroscopeRaw(requestParameters: PostApiCalcChineseHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ChineseHoroscopeResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/chinese-horoscope`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ChineseHoroscopeRequestToJSON(requestParameters['chineseHoroscopeRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ChineseHoroscopeResponseFromJSON(jsonValue));
    }

    /**
     * Calculate the Chinese zodiac sign and element based on birth year.
     * Chinese Zodiac Sign
     */
    async postApiCalcChineseHoroscope(requestParameters: PostApiCalcChineseHoroscopeRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ChineseHoroscopeResponse> {
        const response = await this.postApiCalcChineseHoroscopeRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate sun sign compatibility between two people with interpretation text.
     * Compatibility Analysis
     */
    async postApiCalcCompatibilityRaw(requestParameters: PostApiCalcCompatibilityRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CompatibilityResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/compatibility`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CompatibilityRequestToJSON(requestParameters['compatibilityRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => CompatibilityResponseFromJSON(jsonValue));
    }

    /**
     * Calculate sun sign compatibility between two people with interpretation text.
     * Compatibility Analysis
     */
    async postApiCalcCompatibility(requestParameters: PostApiCalcCompatibilityRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CompatibilityResponse> {
        const response = await this.postApiCalcCompatibilityRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate a composite chart by combining midpoints of two birth charts.
     * Composite Chart
     */
    async postApiCalcCompositeRaw(requestParameters: PostApiCalcCompositeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CompositeResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/composite`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CompositeRequestToJSON(requestParameters['compositeRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => CompositeResponseFromJSON(jsonValue));
    }

    /**
     * Calculate a composite chart by combining midpoints of two birth charts.
     * Composite Chart
     */
    async postApiCalcComposite(requestParameters: PostApiCalcCompositeRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CompositeResponse> {
        const response = await this.postApiCalcCompositeRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate the lunar return chart when the Moon returns to its natal position.
     * Lunar Return
     */
    async postApiCalcLunarReturnRaw(requestParameters: PostApiCalcLunarReturnRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LunarReturnResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/lunar-return`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LunarReturnRequestToJSON(requestParameters['lunarReturnRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => LunarReturnResponseFromJSON(jsonValue));
    }

    /**
     * Calculate the lunar return chart when the Moon returns to its natal position.
     * Lunar Return
     */
    async postApiCalcLunarReturn(requestParameters: PostApiCalcLunarReturnRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LunarReturnResponse> {
        const response = await this.postApiCalcLunarReturnRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.
     * Moon & Sun Info
     */
    async postApiCalcMoonSunRaw(requestParameters: PostApiCalcMoonSunRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<MoonSunResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/moon-sun`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: MoonSunRequestToJSON(requestParameters['moonSunRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => MoonSunResponseFromJSON(jsonValue));
    }

    /**
     * Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.
     * Moon & Sun Info
     */
    async postApiCalcMoonSun(requestParameters: PostApiCalcMoonSunRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<MoonSunResponse> {
        const response = await this.postApiCalcMoonSunRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.
     * Natal Chart
     */
    async postApiCalcNatalRaw(requestParameters: PostApiCalcNatalRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NatalResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/natal`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: NatalRequestToJSON(requestParameters['natalRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NatalResponseFromJSON(jsonValue));
    }

    /**
     * Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.
     * Natal Chart
     */
    async postApiCalcNatal(requestParameters: PostApiCalcNatalRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NatalResponse> {
        const response = await this.postApiCalcNatalRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.
     * Secondary Progressions
     */
    async postApiCalcProgressionsRaw(requestParameters: PostApiCalcProgressionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ProgressionsResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/progressions`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ProgressionsRequestToJSON(requestParameters['progressionsRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ProgressionsResponseFromJSON(jsonValue));
    }

    /**
     * Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.
     * Secondary Progressions
     */
    async postApiCalcProgressions(requestParameters: PostApiCalcProgressionsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ProgressionsResponse> {
        const response = await this.postApiCalcProgressionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate the solar return chart for a specific year (birthday chart).
     * Solar Return
     */
    async postApiCalcSolarReturnRaw(requestParameters: PostApiCalcSolarReturnRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SolarReturnResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/solar-return`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: SolarReturnRequestToJSON(requestParameters['solarReturnRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SolarReturnResponseFromJSON(jsonValue));
    }

    /**
     * Calculate the solar return chart for a specific year (birthday chart).
     * Solar Return
     */
    async postApiCalcSolarReturn(requestParameters: PostApiCalcSolarReturnRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SolarReturnResponse> {
        const response = await this.postApiCalcSolarReturnRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate synastry aspects between two birth charts for relationship analysis.
     * Synastry Chart
     */
    async postApiCalcSynastryRaw(requestParameters: PostApiCalcSynastryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SynastryResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/synastry`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: SynastryRequestToJSON(requestParameters['synastryRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SynastryResponseFromJSON(jsonValue));
    }

    /**
     * Calculate synastry aspects between two birth charts for relationship analysis.
     * Synastry Chart
     */
    async postApiCalcSynastry(requestParameters: PostApiCalcSynastryRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SynastryResponse> {
        const response = await this.postApiCalcSynastryRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Calculate planetary transits over a natal chart for a specified time period.
     * Transit Chart
     */
    async postApiCalcTransitRaw(requestParameters: PostApiCalcTransitRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TransitResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/calc/transit`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: TransitRequestToJSON(requestParameters['transitRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TransitResponseFromJSON(jsonValue));
    }

    /**
     * Calculate planetary transits over a natal chart for a specified time period.
     * Transit Chart
     */
    async postApiCalcTransit(requestParameters: PostApiCalcTransitRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TransitResponse> {
        const response = await this.postApiCalcTransitRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
