/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ChatDirectRequest,
  ChatRequest,
} from '../models/index';
import {
    ChatDirectRequestFromJSON,
    ChatDirectRequestToJSON,
    ChatRequestFromJSON,
    ChatRequestToJSON,
} from '../models/index';

export interface ChatOperationRequest {
    chatbotId: string | null;
    chatRequest?: ChatRequest;
}

export interface ChatDirectOperationRequest {
    chatbotId: string;
    chatDirectRequest?: ChatDirectRequest;
}

export interface ChatWithProfileRequest {
    chatbotId: string;
    profileId: string;
    chatRequest?: ChatRequest;
}

export interface DeleteConversationRequest {
    chatbotId: string;
    conversationId: string;
}

export interface GetConversationRequest {
    chatbotId: string;
    conversationId: string | null;
}

/**
 * ChatApi - interface
 * 
 * @export
 * @interface ChatApiInterface
 */
export interface ChatApiInterface {
    /**
     * Send a message to a chatbot and receive a streaming response via SSE
     * @summary Chat with Chatbot
     * @param {string} chatbotId 
     * @param {ChatRequest} [chatRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatApiInterface
     */
    chatRaw(requestParameters: ChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Send a message to a chatbot and receive a streaming response via SSE
     * Chat with Chatbot
     */
    chat(requestParameters: ChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Send a message with inline birth data (no profile needed)
     * @summary Chat with Birth Data
     * @param {string} chatbotId 
     * @param {ChatDirectRequest} [chatDirectRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatApiInterface
     */
    chatDirectRaw(requestParameters: ChatDirectOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Send a message with inline birth data (no profile needed)
     * Chat with Birth Data
     */
    chatDirect(requestParameters: ChatDirectOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Send a message using a pre-configured user profile
     * @summary Chat with Profile
     * @param {string} chatbotId 
     * @param {string} profileId 
     * @param {ChatRequest} [chatRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatApiInterface
     */
    chatWithProfileRaw(requestParameters: ChatWithProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Send a message using a pre-configured user profile
     * Chat with Profile
     */
    chatWithProfile(requestParameters: ChatWithProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Delete a conversation and its history
     * @summary Delete Conversation
     * @param {string} chatbotId 
     * @param {string} conversationId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatApiInterface
     */
    deleteConversationRaw(requestParameters: DeleteConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete a conversation and its history
     * Delete Conversation
     */
    deleteConversation(requestParameters: DeleteConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Retrieve conversation history
     * @summary Get Conversation
     * @param {string} chatbotId 
     * @param {string} conversationId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatApiInterface
     */
    getConversationRaw(requestParameters: GetConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Retrieve conversation history
     * Get Conversation
     */
    getConversation(requestParameters: GetConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

}

/**
 * 
 */
export class ChatApi extends runtime.BaseAPI implements ChatApiInterface {

    /**
     * Send a message to a chatbot and receive a streaming response via SSE
     * Chat with Chatbot
     */
    async chatRaw(requestParameters: ChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling chat().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chat/{chatbotId}`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ChatRequestToJSON(requestParameters['chatRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Send a message to a chatbot and receive a streaming response via SSE
     * Chat with Chatbot
     */
    async chat(requestParameters: ChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.chatRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Send a message with inline birth data (no profile needed)
     * Chat with Birth Data
     */
    async chatDirectRaw(requestParameters: ChatDirectOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling chatDirect().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chat/{chatbotId}/direct`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ChatDirectRequestToJSON(requestParameters['chatDirectRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Send a message with inline birth data (no profile needed)
     * Chat with Birth Data
     */
    async chatDirect(requestParameters: ChatDirectOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.chatDirectRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Send a message using a pre-configured user profile
     * Chat with Profile
     */
    async chatWithProfileRaw(requestParameters: ChatWithProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling chatWithProfile().'
            );
        }

        if (requestParameters['profileId'] == null) {
            throw new runtime.RequiredError(
                'profileId',
                'Required parameter "profileId" was null or undefined when calling chatWithProfile().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chat/{chatbotId}/profile/{profileId}`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));
        urlPath = urlPath.replace(`{${"profileId"}}`, encodeURIComponent(String(requestParameters['profileId'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ChatRequestToJSON(requestParameters['chatRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Send a message using a pre-configured user profile
     * Chat with Profile
     */
    async chatWithProfile(requestParameters: ChatWithProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.chatWithProfileRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Delete a conversation and its history
     * Delete Conversation
     */
    async deleteConversationRaw(requestParameters: DeleteConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling deleteConversation().'
            );
        }

        if (requestParameters['conversationId'] == null) {
            throw new runtime.RequiredError(
                'conversationId',
                'Required parameter "conversationId" was null or undefined when calling deleteConversation().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chat/{chatbotId}/conversation/{conversationId}`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));
        urlPath = urlPath.replace(`{${"conversationId"}}`, encodeURIComponent(String(requestParameters['conversationId'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete a conversation and its history
     * Delete Conversation
     */
    async deleteConversation(requestParameters: DeleteConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteConversationRaw(requestParameters, initOverrides);
    }

    /**
     * Retrieve conversation history
     * Get Conversation
     */
    async getConversationRaw(requestParameters: GetConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling getConversation().'
            );
        }

        if (requestParameters['conversationId'] == null) {
            throw new runtime.RequiredError(
                'conversationId',
                'Required parameter "conversationId" was null or undefined when calling getConversation().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chat/{chatbotId}/conversation/{conversationId}`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));
        urlPath = urlPath.replace(`{${"conversationId"}}`, encodeURIComponent(String(requestParameters['conversationId'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Retrieve conversation history
     * Get Conversation
     */
    async getConversation(requestParameters: GetConversationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.getConversationRaw(requestParameters, initOverrides);
    }

}
