/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  CreateChatProfileRequest,
  CreateChatbotRequest,
  UpdateChatbotRequest,
} from '../models/index';
import {
    CreateChatProfileRequestFromJSON,
    CreateChatProfileRequestToJSON,
    CreateChatbotRequestFromJSON,
    CreateChatbotRequestToJSON,
    UpdateChatbotRequestFromJSON,
    UpdateChatbotRequestToJSON,
} from '../models/index';

export interface CreateChatProfileOperationRequest {
    id: string;
    createChatProfileRequest?: CreateChatProfileRequest;
}

export interface CreateChatbotOperationRequest {
    createChatbotRequest?: CreateChatbotRequest;
}

export interface DeleteChatProfileRequest {
    id: string;
    profileId: string | null;
}

export interface DeleteChatbotRequest {
    id: string;
}

export interface GetChatbotRequest {
    id: string;
}

export interface ListChatProfilesRequest {
    id: string;
}

export interface UpdateChatbotOperationRequest {
    id: string;
    updateChatbotRequest?: UpdateChatbotRequest;
}

/**
 * ChatbotApi - interface
 * 
 * @export
 * @interface ChatbotApiInterface
 */
export interface ChatbotApiInterface {
    /**
     * Create a pre-configured chat profile with birth data
     * @summary Create Chat Profile
     * @param {string} id 
     * @param {CreateChatProfileRequest} [createChatProfileRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    createChatProfileRaw(requestParameters: CreateChatProfileOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Create a pre-configured chat profile with birth data
     * Create Chat Profile
     */
    createChatProfile(requestParameters: CreateChatProfileOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Create a new chatbot for the organization
     * @summary Create Chatbot
     * @param {CreateChatbotRequest} [createChatbotRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    createChatbotRaw(requestParameters: CreateChatbotOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Create a new chatbot for the organization
     * Create Chatbot
     */
    createChatbot(requestParameters: CreateChatbotOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Delete a chat profile
     * @summary Delete Chat Profile
     * @param {string} id 
     * @param {string} profileId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    deleteChatProfileRaw(requestParameters: DeleteChatProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete a chat profile
     * Delete Chat Profile
     */
    deleteChatProfile(requestParameters: DeleteChatProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Delete a chatbot
     * @summary Delete Chatbot
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    deleteChatbotRaw(requestParameters: DeleteChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete a chatbot
     * Delete Chatbot
     */
    deleteChatbot(requestParameters: DeleteChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Get a specific chatbot by ID
     * @summary Get Chatbot
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    getChatbotRaw(requestParameters: GetChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Get a specific chatbot by ID
     * Get Chatbot
     */
    getChatbot(requestParameters: GetChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Get chatbot usage statistics for the current organization
     * @summary Get Chatbot Usage
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    getChatbotUsageRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Get chatbot usage statistics for the current organization
     * Get Chatbot Usage
     */
    getChatbotUsage(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * List all chat profiles for a chatbot
     * @summary List Chat Profiles
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    listChatProfilesRaw(requestParameters: ListChatProfilesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * List all chat profiles for a chatbot
     * List Chat Profiles
     */
    listChatProfiles(requestParameters: ListChatProfilesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * List all available chatbot plugins
     * @summary List Available Plugins
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    listChatbotPluginsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * List all available chatbot plugins
     * List Available Plugins
     */
    listChatbotPlugins(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * List all chatbots for the current organization
     * @summary List Chatbots
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    listChatbotsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * List all chatbots for the current organization
     * List Chatbots
     */
    listChatbots(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Update an existing chatbot
     * @summary Update Chatbot
     * @param {string} id 
     * @param {UpdateChatbotRequest} [updateChatbotRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ChatbotApiInterface
     */
    updateChatbotRaw(requestParameters: UpdateChatbotOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Update an existing chatbot
     * Update Chatbot
     */
    updateChatbot(requestParameters: UpdateChatbotOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

}

/**
 * 
 */
export class ChatbotApi extends runtime.BaseAPI implements ChatbotApiInterface {

    /**
     * Create a pre-configured chat profile with birth data
     * Create Chat Profile
     */
    async createChatProfileRaw(requestParameters: CreateChatProfileOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling createChatProfile().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/{id}/profiles`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CreateChatProfileRequestToJSON(requestParameters['createChatProfileRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Create a pre-configured chat profile with birth data
     * Create Chat Profile
     */
    async createChatProfile(requestParameters: CreateChatProfileOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.createChatProfileRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create a new chatbot for the organization
     * Create Chatbot
     */
    async createChatbotRaw(requestParameters: CreateChatbotOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CreateChatbotRequestToJSON(requestParameters['createChatbotRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Create a new chatbot for the organization
     * Create Chatbot
     */
    async createChatbot(requestParameters: CreateChatbotOperationRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.createChatbotRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Delete a chat profile
     * Delete Chat Profile
     */
    async deleteChatProfileRaw(requestParameters: DeleteChatProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling deleteChatProfile().'
            );
        }

        if (requestParameters['profileId'] == null) {
            throw new runtime.RequiredError(
                'profileId',
                'Required parameter "profileId" was null or undefined when calling deleteChatProfile().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/{id}/profiles/{profileId}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));
        urlPath = urlPath.replace(`{${"profileId"}}`, encodeURIComponent(String(requestParameters['profileId'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete a chat profile
     * Delete Chat Profile
     */
    async deleteChatProfile(requestParameters: DeleteChatProfileRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteChatProfileRaw(requestParameters, initOverrides);
    }

    /**
     * Delete a chatbot
     * Delete Chatbot
     */
    async deleteChatbotRaw(requestParameters: DeleteChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling deleteChatbot().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete a chatbot
     * Delete Chatbot
     */
    async deleteChatbot(requestParameters: DeleteChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteChatbotRaw(requestParameters, initOverrides);
    }

    /**
     * Get a specific chatbot by ID
     * Get Chatbot
     */
    async getChatbotRaw(requestParameters: GetChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling getChatbot().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Get a specific chatbot by ID
     * Get Chatbot
     */
    async getChatbot(requestParameters: GetChatbotRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.getChatbotRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get chatbot usage statistics for the current organization
     * Get Chatbot Usage
     */
    async getChatbotUsageRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/usage`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Get chatbot usage statistics for the current organization
     * Get Chatbot Usage
     */
    async getChatbotUsage(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.getChatbotUsageRaw(initOverrides);
        return await response.value();
    }

    /**
     * List all chat profiles for a chatbot
     * List Chat Profiles
     */
    async listChatProfilesRaw(requestParameters: ListChatProfilesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling listChatProfiles().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/{id}/profiles`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * List all chat profiles for a chatbot
     * List Chat Profiles
     */
    async listChatProfiles(requestParameters: ListChatProfilesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.listChatProfilesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * List all available chatbot plugins
     * List Available Plugins
     */
    async listChatbotPluginsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/plugins`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * List all available chatbot plugins
     * List Available Plugins
     */
    async listChatbotPlugins(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.listChatbotPluginsRaw(initOverrides);
        return await response.value();
    }

    /**
     * List all chatbots for the current organization
     * List Chatbots
     */
    async listChatbotsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * List all chatbots for the current organization
     * List Chatbots
     */
    async listChatbots(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.listChatbotsRaw(initOverrides);
        return await response.value();
    }

    /**
     * Update an existing chatbot
     * Update Chatbot
     */
    async updateChatbotRaw(requestParameters: UpdateChatbotOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling updateChatbot().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/chatbots/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: UpdateChatbotRequestToJSON(requestParameters['updateChatbotRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Update an existing chatbot
     * Update Chatbot
     */
    async updateChatbot(requestParameters: UpdateChatbotOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.updateChatbotRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
