/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ContentResponse,
} from '../models/index';
import {
    ContentResponseFromJSON,
    ContentResponseToJSON,
} from '../models/index';

export interface CreateContentRequest {
    horoscopeType: string;
    contentType: string;
}

export interface CreateContentCustomCopyRequest {
    id: string;
}

export interface DeleteContentRequest {
    id: string;
    horoscopeType: string;
    contentType: string;
}

export interface DeleteContentByIdRequest {
    id: string;
}

export interface GetContentRequest {
    id: string;
    horoscopeType: string;
    contentType: string;
}

export interface ListContentRequest {
    horoscopeType: string | null;
    contentType: string | null;
}

export interface RestoreContentRequest {
    id: string;
}

/**
 * ContentApi - interface
 * 
 * @export
 * @interface ContentApiInterface
 */
export interface ContentApiInterface {
    /**
     * Create a new content item for a specific horoscope and content type.
     * @summary Create Content
     * @param {string} horoscopeType 
     * @param {string} contentType 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ContentApiInterface
     */
    createContentRaw(requestParameters: CreateContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>>;

    /**
     * Create a new content item for a specific horoscope and content type.
     * Create Content
     */
    createContent(requestParameters: CreateContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse>;

    /**
     * Create an organization-specific copy of system content for customization.
     * @summary Create Custom Copy
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ContentApiInterface
     */
    createContentCustomCopyRaw(requestParameters: CreateContentCustomCopyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>>;

    /**
     * Create an organization-specific copy of system content for customization.
     * Create Custom Copy
     */
    createContentCustomCopy(requestParameters: CreateContentCustomCopyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse>;

    /**
     * Delete a content item by horoscope type, content type, and ID.
     * @summary Delete Content
     * @param {string} id 
     * @param {string} horoscopeType 
     * @param {string} contentType 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ContentApiInterface
     */
    deleteContentRaw(requestParameters: DeleteContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete a content item by horoscope type, content type, and ID.
     * Delete Content
     */
    deleteContent(requestParameters: DeleteContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Delete a content item by its ID.
     * @summary Delete Content by ID
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ContentApiInterface
     */
    deleteContentByIdRaw(requestParameters: DeleteContentByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>>;

    /**
     * Delete a content item by its ID.
     * Delete Content by ID
     */
    deleteContentById(requestParameters: DeleteContentByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse>;

    /**
     * Retrieve a single content item by its ID.
     * @summary Get Content
     * @param {string} id 
     * @param {string} horoscopeType 
     * @param {string} contentType 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ContentApiInterface
     */
    getContentRaw(requestParameters: GetContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>>;

    /**
     * Retrieve a single content item by its ID.
     * Get Content
     */
    getContent(requestParameters: GetContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse>;

    /**
     * Retrieve a paginated list of content items filtered by horoscope and content type.
     * @summary List Content
     * @param {string} horoscopeType 
     * @param {string} contentType 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ContentApiInterface
     */
    listContentRaw(requestParameters: ListContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>>;

    /**
     * Retrieve a paginated list of content items filtered by horoscope and content type.
     * List Content
     */
    listContent(requestParameters: ListContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse>;

    /**
     * Restore custom content to match the original system content.
     * @summary Restore Content
     * @param {string} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ContentApiInterface
     */
    restoreContentRaw(requestParameters: RestoreContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>>;

    /**
     * Restore custom content to match the original system content.
     * Restore Content
     */
    restoreContent(requestParameters: RestoreContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse>;

}

/**
 * 
 */
export class ContentApi extends runtime.BaseAPI implements ContentApiInterface {

    /**
     * Create a new content item for a specific horoscope and content type.
     * Create Content
     */
    async createContentRaw(requestParameters: CreateContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>> {
        if (requestParameters['horoscopeType'] == null) {
            throw new runtime.RequiredError(
                'horoscopeType',
                'Required parameter "horoscopeType" was null or undefined when calling createContent().'
            );
        }

        if (requestParameters['contentType'] == null) {
            throw new runtime.RequiredError(
                'contentType',
                'Required parameter "contentType" was null or undefined when calling createContent().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/content/{horoscopeType}/{contentType}`;
        urlPath = urlPath.replace(`{${"horoscopeType"}}`, encodeURIComponent(String(requestParameters['horoscopeType'])));
        urlPath = urlPath.replace(`{${"contentType"}}`, encodeURIComponent(String(requestParameters['contentType'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ContentResponseFromJSON(jsonValue));
    }

    /**
     * Create a new content item for a specific horoscope and content type.
     * Create Content
     */
    async createContent(requestParameters: CreateContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse> {
        const response = await this.createContentRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create an organization-specific copy of system content for customization.
     * Create Custom Copy
     */
    async createContentCustomCopyRaw(requestParameters: CreateContentCustomCopyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling createContentCustomCopy().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/content/{id}/create-custom-copy`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ContentResponseFromJSON(jsonValue));
    }

    /**
     * Create an organization-specific copy of system content for customization.
     * Create Custom Copy
     */
    async createContentCustomCopy(requestParameters: CreateContentCustomCopyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse> {
        const response = await this.createContentCustomCopyRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Delete a content item by horoscope type, content type, and ID.
     * Delete Content
     */
    async deleteContentRaw(requestParameters: DeleteContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling deleteContent().'
            );
        }

        if (requestParameters['horoscopeType'] == null) {
            throw new runtime.RequiredError(
                'horoscopeType',
                'Required parameter "horoscopeType" was null or undefined when calling deleteContent().'
            );
        }

        if (requestParameters['contentType'] == null) {
            throw new runtime.RequiredError(
                'contentType',
                'Required parameter "contentType" was null or undefined when calling deleteContent().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/content/{horoscopeType}/{contentType}/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));
        urlPath = urlPath.replace(`{${"horoscopeType"}}`, encodeURIComponent(String(requestParameters['horoscopeType'])));
        urlPath = urlPath.replace(`{${"contentType"}}`, encodeURIComponent(String(requestParameters['contentType'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete a content item by horoscope type, content type, and ID.
     * Delete Content
     */
    async deleteContent(requestParameters: DeleteContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteContentRaw(requestParameters, initOverrides);
    }

    /**
     * Delete a content item by its ID.
     * Delete Content by ID
     */
    async deleteContentByIdRaw(requestParameters: DeleteContentByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling deleteContentById().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/content/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ContentResponseFromJSON(jsonValue));
    }

    /**
     * Delete a content item by its ID.
     * Delete Content by ID
     */
    async deleteContentById(requestParameters: DeleteContentByIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse> {
        const response = await this.deleteContentByIdRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve a single content item by its ID.
     * Get Content
     */
    async getContentRaw(requestParameters: GetContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling getContent().'
            );
        }

        if (requestParameters['horoscopeType'] == null) {
            throw new runtime.RequiredError(
                'horoscopeType',
                'Required parameter "horoscopeType" was null or undefined when calling getContent().'
            );
        }

        if (requestParameters['contentType'] == null) {
            throw new runtime.RequiredError(
                'contentType',
                'Required parameter "contentType" was null or undefined when calling getContent().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/content/{horoscopeType}/{contentType}/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));
        urlPath = urlPath.replace(`{${"horoscopeType"}}`, encodeURIComponent(String(requestParameters['horoscopeType'])));
        urlPath = urlPath.replace(`{${"contentType"}}`, encodeURIComponent(String(requestParameters['contentType'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ContentResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve a single content item by its ID.
     * Get Content
     */
    async getContent(requestParameters: GetContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse> {
        const response = await this.getContentRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve a paginated list of content items filtered by horoscope and content type.
     * List Content
     */
    async listContentRaw(requestParameters: ListContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>> {
        if (requestParameters['horoscopeType'] == null) {
            throw new runtime.RequiredError(
                'horoscopeType',
                'Required parameter "horoscopeType" was null or undefined when calling listContent().'
            );
        }

        if (requestParameters['contentType'] == null) {
            throw new runtime.RequiredError(
                'contentType',
                'Required parameter "contentType" was null or undefined when calling listContent().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/content/{horoscopeType}/{contentType}`;
        urlPath = urlPath.replace(`{${"horoscopeType"}}`, encodeURIComponent(String(requestParameters['horoscopeType'])));
        urlPath = urlPath.replace(`{${"contentType"}}`, encodeURIComponent(String(requestParameters['contentType'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ContentResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve a paginated list of content items filtered by horoscope and content type.
     * List Content
     */
    async listContent(requestParameters: ListContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse> {
        const response = await this.listContentRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Restore custom content to match the original system content.
     * Restore Content
     */
    async restoreContentRaw(requestParameters: RestoreContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContentResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling restoreContent().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/content/{id}/restore`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ContentResponseFromJSON(jsonValue));
    }

    /**
     * Restore custom content to match the original system content.
     * Restore Content
     */
    async restoreContent(requestParameters: RestoreContentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContentResponse> {
        const response = await this.restoreContentRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
