/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  DailyHoroscopeResponse,
  HoroscopeReportResponse,
} from '../models/index';
import {
    DailyHoroscopeResponseFromJSON,
    DailyHoroscopeResponseToJSON,
    HoroscopeReportResponseFromJSON,
    HoroscopeReportResponseToJSON,
} from '../models/index';

export interface GetDailyHoroscopesRequest {
    date: string;
}

export interface GetWeeklyHoroscopeRequest {
    year: string;
    week: string;
    zodiacSign: string | null;
}

export interface GetYearlyAscendantHoroscopeRequest {
    year: string;
    zodiacSign: string;
}

export interface GetYearlyHoroscopeRequest {
    year: string;
    zodiacSign: string;
}

/**
 * HoroscopeApi - interface
 * 
 * @export
 * @interface HoroscopeApiInterface
 */
export interface HoroscopeApiInterface {
    /**
     * Retrieve daily horoscopes for all zodiac signs for a specific date.
     * @summary Get Daily Horoscopes
     * @param {string} date 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof HoroscopeApiInterface
     */
    getDailyHoroscopesRaw(requestParameters: GetDailyHoroscopesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DailyHoroscopeResponse>>;

    /**
     * Retrieve daily horoscopes for all zodiac signs for a specific date.
     * Get Daily Horoscopes
     */
    getDailyHoroscopes(requestParameters: GetDailyHoroscopesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DailyHoroscopeResponse>;

    /**
     * Retrieve weekly horoscope report for a specific zodiac sign and week.
     * @summary Get Weekly Horoscope Report
     * @param {string} year 
     * @param {string} week 
     * @param {string} zodiacSign 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof HoroscopeApiInterface
     */
    getWeeklyHoroscopeRaw(requestParameters: GetWeeklyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<HoroscopeReportResponse>>;

    /**
     * Retrieve weekly horoscope report for a specific zodiac sign and week.
     * Get Weekly Horoscope Report
     */
    getWeeklyHoroscope(requestParameters: GetWeeklyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<HoroscopeReportResponse>;

    /**
     * Retrieve yearly horoscope report for a specific ascendant sign and year.
     * @summary Get Yearly Ascendant Horoscope Report
     * @param {string} year 
     * @param {string} zodiacSign 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof HoroscopeApiInterface
     */
    getYearlyAscendantHoroscopeRaw(requestParameters: GetYearlyAscendantHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<HoroscopeReportResponse>>;

    /**
     * Retrieve yearly horoscope report for a specific ascendant sign and year.
     * Get Yearly Ascendant Horoscope Report
     */
    getYearlyAscendantHoroscope(requestParameters: GetYearlyAscendantHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<HoroscopeReportResponse>;

    /**
     * Retrieve yearly horoscope report for a specific zodiac sign and year.
     * @summary Get Yearly Horoscope Report
     * @param {string} year 
     * @param {string} zodiacSign 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof HoroscopeApiInterface
     */
    getYearlyHoroscopeRaw(requestParameters: GetYearlyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<HoroscopeReportResponse>>;

    /**
     * Retrieve yearly horoscope report for a specific zodiac sign and year.
     * Get Yearly Horoscope Report
     */
    getYearlyHoroscope(requestParameters: GetYearlyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<HoroscopeReportResponse>;

}

/**
 * 
 */
export class HoroscopeApi extends runtime.BaseAPI implements HoroscopeApiInterface {

    /**
     * Retrieve daily horoscopes for all zodiac signs for a specific date.
     * Get Daily Horoscopes
     */
    async getDailyHoroscopesRaw(requestParameters: GetDailyHoroscopesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DailyHoroscopeResponse>> {
        if (requestParameters['date'] == null) {
            throw new runtime.RequiredError(
                'date',
                'Required parameter "date" was null or undefined when calling getDailyHoroscopes().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/horoscope/daily/{date}`;
        urlPath = urlPath.replace(`{${"date"}}`, encodeURIComponent(String(requestParameters['date'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DailyHoroscopeResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve daily horoscopes for all zodiac signs for a specific date.
     * Get Daily Horoscopes
     */
    async getDailyHoroscopes(requestParameters: GetDailyHoroscopesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DailyHoroscopeResponse> {
        const response = await this.getDailyHoroscopesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve weekly horoscope report for a specific zodiac sign and week.
     * Get Weekly Horoscope Report
     */
    async getWeeklyHoroscopeRaw(requestParameters: GetWeeklyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<HoroscopeReportResponse>> {
        if (requestParameters['year'] == null) {
            throw new runtime.RequiredError(
                'year',
                'Required parameter "year" was null or undefined when calling getWeeklyHoroscope().'
            );
        }

        if (requestParameters['week'] == null) {
            throw new runtime.RequiredError(
                'week',
                'Required parameter "week" was null or undefined when calling getWeeklyHoroscope().'
            );
        }

        if (requestParameters['zodiacSign'] == null) {
            throw new runtime.RequiredError(
                'zodiacSign',
                'Required parameter "zodiacSign" was null or undefined when calling getWeeklyHoroscope().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/horoscope/weekly/{year}/{week}/{zodiacSign}`;
        urlPath = urlPath.replace(`{${"year"}}`, encodeURIComponent(String(requestParameters['year'])));
        urlPath = urlPath.replace(`{${"week"}}`, encodeURIComponent(String(requestParameters['week'])));
        urlPath = urlPath.replace(`{${"zodiacSign"}}`, encodeURIComponent(String(requestParameters['zodiacSign'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => HoroscopeReportResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve weekly horoscope report for a specific zodiac sign and week.
     * Get Weekly Horoscope Report
     */
    async getWeeklyHoroscope(requestParameters: GetWeeklyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<HoroscopeReportResponse> {
        const response = await this.getWeeklyHoroscopeRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve yearly horoscope report for a specific ascendant sign and year.
     * Get Yearly Ascendant Horoscope Report
     */
    async getYearlyAscendantHoroscopeRaw(requestParameters: GetYearlyAscendantHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<HoroscopeReportResponse>> {
        if (requestParameters['year'] == null) {
            throw new runtime.RequiredError(
                'year',
                'Required parameter "year" was null or undefined when calling getYearlyAscendantHoroscope().'
            );
        }

        if (requestParameters['zodiacSign'] == null) {
            throw new runtime.RequiredError(
                'zodiacSign',
                'Required parameter "zodiacSign" was null or undefined when calling getYearlyAscendantHoroscope().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/horoscope/yearly-ascendant/{year}/{zodiacSign}`;
        urlPath = urlPath.replace(`{${"year"}}`, encodeURIComponent(String(requestParameters['year'])));
        urlPath = urlPath.replace(`{${"zodiacSign"}}`, encodeURIComponent(String(requestParameters['zodiacSign'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => HoroscopeReportResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve yearly horoscope report for a specific ascendant sign and year.
     * Get Yearly Ascendant Horoscope Report
     */
    async getYearlyAscendantHoroscope(requestParameters: GetYearlyAscendantHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<HoroscopeReportResponse> {
        const response = await this.getYearlyAscendantHoroscopeRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve yearly horoscope report for a specific zodiac sign and year.
     * Get Yearly Horoscope Report
     */
    async getYearlyHoroscopeRaw(requestParameters: GetYearlyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<HoroscopeReportResponse>> {
        if (requestParameters['year'] == null) {
            throw new runtime.RequiredError(
                'year',
                'Required parameter "year" was null or undefined when calling getYearlyHoroscope().'
            );
        }

        if (requestParameters['zodiacSign'] == null) {
            throw new runtime.RequiredError(
                'zodiacSign',
                'Required parameter "zodiacSign" was null or undefined when calling getYearlyHoroscope().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/horoscope/yearly/{year}/{zodiacSign}`;
        urlPath = urlPath.replace(`{${"year"}}`, encodeURIComponent(String(requestParameters['year'])));
        urlPath = urlPath.replace(`{${"zodiacSign"}}`, encodeURIComponent(String(requestParameters['zodiacSign'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => HoroscopeReportResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve yearly horoscope report for a specific zodiac sign and year.
     * Get Yearly Horoscope Report
     */
    async getYearlyHoroscope(requestParameters: GetYearlyHoroscopeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<HoroscopeReportResponse> {
        const response = await this.getYearlyHoroscopeRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
