/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  GetApiModules200Response,
  GetApiModulesOrganization200Response,
  GetApiModulesPlans200Response,
  ModuleAccessCheck,
} from '../models/index';
import {
    GetApiModules200ResponseFromJSON,
    GetApiModules200ResponseToJSON,
    GetApiModulesOrganization200ResponseFromJSON,
    GetApiModulesOrganization200ResponseToJSON,
    GetApiModulesPlans200ResponseFromJSON,
    GetApiModulesPlans200ResponseToJSON,
    ModuleAccessCheckFromJSON,
    ModuleAccessCheckToJSON,
} from '../models/index';

export interface GetApiModulesCheckModuleIdRequest {
    moduleId: string | null;
}

/**
 * ModulesApi - interface
 * 
 * @export
 * @interface ModulesApiInterface
 */
export interface ModulesApiInterface {
    /**
     * Get all available modules with pricing information.
     * @summary List Modules
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ModulesApiInterface
     */
    getApiModulesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiModules200Response>>;

    /**
     * Get all available modules with pricing information.
     * List Modules
     */
    getApiModules(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiModules200Response>;

    /**
     * Check if the current organization has access to a specific module.
     * @summary Check Module Access
     * @param {string} moduleId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ModulesApiInterface
     */
    getApiModulesCheckModuleIdRaw(requestParameters: GetApiModulesCheckModuleIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModuleAccessCheck>>;

    /**
     * Check if the current organization has access to a specific module.
     * Check Module Access
     */
    getApiModulesCheckModuleId(requestParameters: GetApiModulesCheckModuleIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModuleAccessCheck>;

    /**
     * Get the list of modules the current organization has access to.
     * @summary Organization Modules
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ModulesApiInterface
     */
    getApiModulesOrganizationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiModulesOrganization200Response>>;

    /**
     * Get the list of modules the current organization has access to.
     * Organization Modules
     */
    getApiModulesOrganization(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiModulesOrganization200Response>;

    /**
     * Get all available subscription plans with included modules and pricing.
     * @summary Subscription Plans
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ModulesApiInterface
     */
    getApiModulesPlansRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiModulesPlans200Response>>;

    /**
     * Get all available subscription plans with included modules and pricing.
     * Subscription Plans
     */
    getApiModulesPlans(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiModulesPlans200Response>;

}

/**
 * 
 */
export class ModulesApi extends runtime.BaseAPI implements ModulesApiInterface {

    /**
     * Get all available modules with pricing information.
     * List Modules
     */
    async getApiModulesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiModules200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/modules`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetApiModules200ResponseFromJSON(jsonValue));
    }

    /**
     * Get all available modules with pricing information.
     * List Modules
     */
    async getApiModules(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiModules200Response> {
        const response = await this.getApiModulesRaw(initOverrides);
        return await response.value();
    }

    /**
     * Check if the current organization has access to a specific module.
     * Check Module Access
     */
    async getApiModulesCheckModuleIdRaw(requestParameters: GetApiModulesCheckModuleIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModuleAccessCheck>> {
        if (requestParameters['moduleId'] == null) {
            throw new runtime.RequiredError(
                'moduleId',
                'Required parameter "moduleId" was null or undefined when calling getApiModulesCheckModuleId().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/modules/check/{moduleId}`;
        urlPath = urlPath.replace(`{${"moduleId"}}`, encodeURIComponent(String(requestParameters['moduleId'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModuleAccessCheckFromJSON(jsonValue));
    }

    /**
     * Check if the current organization has access to a specific module.
     * Check Module Access
     */
    async getApiModulesCheckModuleId(requestParameters: GetApiModulesCheckModuleIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModuleAccessCheck> {
        const response = await this.getApiModulesCheckModuleIdRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the list of modules the current organization has access to.
     * Organization Modules
     */
    async getApiModulesOrganizationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiModulesOrganization200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/modules/organization`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetApiModulesOrganization200ResponseFromJSON(jsonValue));
    }

    /**
     * Get the list of modules the current organization has access to.
     * Organization Modules
     */
    async getApiModulesOrganization(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiModulesOrganization200Response> {
        const response = await this.getApiModulesOrganizationRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get all available subscription plans with included modules and pricing.
     * Subscription Plans
     */
    async getApiModulesPlansRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiModulesPlans200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/modules/plans`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetApiModulesPlans200ResponseFromJSON(jsonValue));
    }

    /**
     * Get all available subscription plans with included modules and pricing.
     * Subscription Plans
     */
    async getApiModulesPlans(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiModulesPlans200Response> {
        const response = await this.getApiModulesPlansRaw(initOverrides);
        return await response.value();
    }

}
