/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  GetApiOrgUsers200Response,
  PatchApiOrgUsersMemberId200Response,
  PatchApiOrgUsersMemberIdRequest,
  PostApiOrgUsers201Response,
  PostApiOrgUsersRequest,
} from '../models/index';
import {
    GetApiOrgUsers200ResponseFromJSON,
    GetApiOrgUsers200ResponseToJSON,
    PatchApiOrgUsersMemberId200ResponseFromJSON,
    PatchApiOrgUsersMemberId200ResponseToJSON,
    PatchApiOrgUsersMemberIdRequestFromJSON,
    PatchApiOrgUsersMemberIdRequestToJSON,
    PostApiOrgUsers201ResponseFromJSON,
    PostApiOrgUsers201ResponseToJSON,
    PostApiOrgUsersRequestFromJSON,
    PostApiOrgUsersRequestToJSON,
} from '../models/index';

export interface DeleteApiOrgUsersMemberIdRequest {
    memberId: string;
}

export interface PatchApiOrgUsersMemberIdOperationRequest {
    memberId: string;
    patchApiOrgUsersMemberIdRequest?: PatchApiOrgUsersMemberIdRequest;
}

export interface PostApiOrgUsersOperationRequest {
    postApiOrgUsersRequest?: PostApiOrgUsersRequest;
}

/**
 * OrganizationsApi - interface
 * 
 * @export
 * @interface OrganizationsApiInterface
 */
export interface OrganizationsApiInterface {
    /**
     * Remove a member from the organization.
     * @summary Remove Member
     * @param {string} memberId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OrganizationsApiInterface
     */
    deleteApiOrgUsersMemberIdRaw(requestParameters: DeleteApiOrgUsersMemberIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Remove a member from the organization.
     * Remove Member
     */
    deleteApiOrgUsersMemberId(requestParameters: DeleteApiOrgUsersMemberIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Get a paginated list of organization members.
     * @summary List Members
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OrganizationsApiInterface
     */
    getApiOrgUsersRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiOrgUsers200Response>>;

    /**
     * Get a paginated list of organization members.
     * List Members
     */
    getApiOrgUsers(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiOrgUsers200Response>;

    /**
     * Update an organization member\'s role.
     * @summary Update Member
     * @param {string} memberId 
     * @param {PatchApiOrgUsersMemberIdRequest} [patchApiOrgUsersMemberIdRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OrganizationsApiInterface
     */
    patchApiOrgUsersMemberIdRaw(requestParameters: PatchApiOrgUsersMemberIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PatchApiOrgUsersMemberId200Response>>;

    /**
     * Update an organization member\'s role.
     * Update Member
     */
    patchApiOrgUsersMemberId(requestParameters: PatchApiOrgUsersMemberIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PatchApiOrgUsersMemberId200Response>;

    /**
     * Create a new organization with Stripe billing setup.
     * @summary Create Organization
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OrganizationsApiInterface
     */
    postApiOrgRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Create a new organization with Stripe billing setup.
     * Create Organization
     */
    postApiOrg(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Add or invite a new member to the organization.
     * @summary Add Member
     * @param {PostApiOrgUsersRequest} [postApiOrgUsersRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OrganizationsApiInterface
     */
    postApiOrgUsersRaw(requestParameters: PostApiOrgUsersOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PostApiOrgUsers201Response>>;

    /**
     * Add or invite a new member to the organization.
     * Add Member
     */
    postApiOrgUsers(requestParameters: PostApiOrgUsersOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PostApiOrgUsers201Response>;

}

/**
 * 
 */
export class OrganizationsApi extends runtime.BaseAPI implements OrganizationsApiInterface {

    /**
     * Remove a member from the organization.
     * Remove Member
     */
    async deleteApiOrgUsersMemberIdRaw(requestParameters: DeleteApiOrgUsersMemberIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['memberId'] == null) {
            throw new runtime.RequiredError(
                'memberId',
                'Required parameter "memberId" was null or undefined when calling deleteApiOrgUsersMemberId().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/org/users/{memberId}`;
        urlPath = urlPath.replace(`{${"memberId"}}`, encodeURIComponent(String(requestParameters['memberId'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Remove a member from the organization.
     * Remove Member
     */
    async deleteApiOrgUsersMemberId(requestParameters: DeleteApiOrgUsersMemberIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteApiOrgUsersMemberIdRaw(requestParameters, initOverrides);
    }

    /**
     * Get a paginated list of organization members.
     * List Members
     */
    async getApiOrgUsersRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetApiOrgUsers200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/org/users`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetApiOrgUsers200ResponseFromJSON(jsonValue));
    }

    /**
     * Get a paginated list of organization members.
     * List Members
     */
    async getApiOrgUsers(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetApiOrgUsers200Response> {
        const response = await this.getApiOrgUsersRaw(initOverrides);
        return await response.value();
    }

    /**
     * Update an organization member\'s role.
     * Update Member
     */
    async patchApiOrgUsersMemberIdRaw(requestParameters: PatchApiOrgUsersMemberIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PatchApiOrgUsersMemberId200Response>> {
        if (requestParameters['memberId'] == null) {
            throw new runtime.RequiredError(
                'memberId',
                'Required parameter "memberId" was null or undefined when calling patchApiOrgUsersMemberId().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/org/users/{memberId}`;
        urlPath = urlPath.replace(`{${"memberId"}}`, encodeURIComponent(String(requestParameters['memberId'])));

        const response = await this.request({
            path: urlPath,
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: PatchApiOrgUsersMemberIdRequestToJSON(requestParameters['patchApiOrgUsersMemberIdRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PatchApiOrgUsersMemberId200ResponseFromJSON(jsonValue));
    }

    /**
     * Update an organization member\'s role.
     * Update Member
     */
    async patchApiOrgUsersMemberId(requestParameters: PatchApiOrgUsersMemberIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PatchApiOrgUsersMemberId200Response> {
        const response = await this.patchApiOrgUsersMemberIdRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create a new organization with Stripe billing setup.
     * Create Organization
     */
    async postApiOrgRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/org`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Create a new organization with Stripe billing setup.
     * Create Organization
     */
    async postApiOrg(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.postApiOrgRaw(initOverrides);
        return await response.value();
    }

    /**
     * Add or invite a new member to the organization.
     * Add Member
     */
    async postApiOrgUsersRaw(requestParameters: PostApiOrgUsersOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PostApiOrgUsers201Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/api/org/users`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: PostApiOrgUsersRequestToJSON(requestParameters['postApiOrgUsersRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PostApiOrgUsers201ResponseFromJSON(jsonValue));
    }

    /**
     * Add or invite a new member to the organization.
     * Add Member
     */
    async postApiOrgUsers(requestParameters: PostApiOrgUsersOperationRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PostApiOrgUsers201Response> {
        const response = await this.postApiOrgUsersRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
