/* tslint:disable */
/* eslint-disable */
/**
 * AstroAPI
 * Professional astrology API for natal charts, transits, synastry, and interpretations
 *
 * The version of the OpenAPI document: 25.12.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  WidgetChatRequest,
  WidgetChatWithUserRequest,
} from '../models/index';
import {
    WidgetChatRequestFromJSON,
    WidgetChatRequestToJSON,
    WidgetChatWithUserRequestFromJSON,
    WidgetChatWithUserRequestToJSON,
} from '../models/index';

export interface GetWidgetConfigRequest {
    chatbotId: string;
}

export interface WidgetChatOperationRequest {
    chatbotId: string;
    widgetChatRequest?: WidgetChatRequest;
}

export interface WidgetChatWithUserOperationRequest {
    chatbotId: string;
    externalUserId: string | null;
    widgetChatWithUserRequest?: WidgetChatWithUserRequest;
}

/**
 * WidgetApi - interface
 * 
 * @export
 * @interface WidgetApiInterface
 */
export interface WidgetApiInterface {
    /**
     * Get the widget configuration for embedding
     * @summary Get Widget Configuration
     * @param {string} chatbotId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WidgetApiInterface
     */
    getWidgetConfigRaw(requestParameters: GetWidgetConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Get the widget configuration for embedding
     * Get Widget Configuration
     */
    getWidgetConfig(requestParameters: GetWidgetConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Send a message via widget (SSE streaming response)
     * @summary Widget Chat
     * @param {string} chatbotId 
     * @param {WidgetChatRequest} [widgetChatRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WidgetApiInterface
     */
    widgetChatRaw(requestParameters: WidgetChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Send a message via widget (SSE streaming response)
     * Widget Chat
     */
    widgetChat(requestParameters: WidgetChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

    /**
     * Chat using an external user ID (creates profile on first use)
     * @summary Widget Chat with User Profile
     * @param {string} chatbotId 
     * @param {string} externalUserId 
     * @param {WidgetChatWithUserRequest} [widgetChatWithUserRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WidgetApiInterface
     */
    widgetChatWithUserRaw(requestParameters: WidgetChatWithUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>>;

    /**
     * Chat using an external user ID (creates profile on first use)
     * Widget Chat with User Profile
     */
    widgetChatWithUser(requestParameters: WidgetChatWithUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any>;

}

/**
 * 
 */
export class WidgetApi extends runtime.BaseAPI implements WidgetApiInterface {

    /**
     * Get the widget configuration for embedding
     * Get Widget Configuration
     */
    async getWidgetConfigRaw(requestParameters: GetWidgetConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling getWidgetConfig().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/widget/config/{chatbotId}`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Get the widget configuration for embedding
     * Get Widget Configuration
     */
    async getWidgetConfig(requestParameters: GetWidgetConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.getWidgetConfigRaw(requestParameters, initOverrides);
    }

    /**
     * Send a message via widget (SSE streaming response)
     * Widget Chat
     */
    async widgetChatRaw(requestParameters: WidgetChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling widgetChat().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/widget/chat/{chatbotId}`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: WidgetChatRequestToJSON(requestParameters['widgetChatRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Send a message via widget (SSE streaming response)
     * Widget Chat
     */
    async widgetChat(requestParameters: WidgetChatOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.widgetChatRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Chat using an external user ID (creates profile on first use)
     * Widget Chat with User Profile
     */
    async widgetChatWithUserRaw(requestParameters: WidgetChatWithUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<any>> {
        if (requestParameters['chatbotId'] == null) {
            throw new runtime.RequiredError(
                'chatbotId',
                'Required parameter "chatbotId" was null or undefined when calling widgetChatWithUser().'
            );
        }

        if (requestParameters['externalUserId'] == null) {
            throw new runtime.RequiredError(
                'externalUserId',
                'Required parameter "externalUserId" was null or undefined when calling widgetChatWithUser().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["X-Api-Key"] = await this.configuration.apiKey("X-Api-Key"); // ApiKeyAuth authentication
        }


        let urlPath = `/widget/chat/{chatbotId}/user/{externalUserId}`;
        urlPath = urlPath.replace(`{${"chatbotId"}}`, encodeURIComponent(String(requestParameters['chatbotId'])));
        urlPath = urlPath.replace(`{${"externalUserId"}}`, encodeURIComponent(String(requestParameters['externalUserId'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: WidgetChatWithUserRequestToJSON(requestParameters['widgetChatWithUserRequest']),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<any>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * Chat using an external user ID (creates profile on first use)
     * Widget Chat with User Profile
     */
    async widgetChatWithUser(requestParameters: WidgetChatWithUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<any> {
        const response = await this.widgetChatWithUserRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
