# APIKeysApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**deleteApiKey**](APIKeysApi.md#deleteapikey) | **DELETE** /api/api-keys/{id} | Delete API Key |
| [**getApiApiKeys**](APIKeysApi.md#getapiapikeys) | **GET** /api/api-keys | List API Keys |
| [**getApiApiKeysAvailableOptions**](APIKeysApi.md#getapiapikeysavailableoptions) | **GET** /api/api-keys/available-options | Available Options |
| [**getApiKey**](APIKeysApi.md#getapikey) | **GET** /api/api-keys/{id} | Get API Key |
| [**postApiApiKeys**](APIKeysApi.md#postapiapikeys) | **POST** /api/api-keys | Create API Key |
| [**updateApiKey**](APIKeysApi.md#updateapikeyoperation) | **PATCH** /api/api-keys/{id} | Update API Key |



## deleteApiKey

> deleteApiKey(id)

Delete API Key

Permanently delete an API key.

### Example

```ts
import {
  Configuration,
  APIKeysApi,
} from '';
import type { DeleteApiKeyRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new APIKeysApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies DeleteApiKeyRequest;

  try {
    const data = await api.deleteApiKey(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | API key deleted |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getApiApiKeys

> GetApiApiKeys200Response getApiApiKeys()

List API Keys

Get all API keys owned by the current user.

### Example

```ts
import {
  Configuration,
  APIKeysApi,
} from '';
import type { GetApiApiKeysRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new APIKeysApi(config);

  try {
    const data = await api.getApiApiKeys();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiApiKeys200Response**](GetApiApiKeys200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of API keys |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getApiApiKeysAvailableOptions

> ApiKeyOptions getApiApiKeysAvailableOptions()

Available Options

Get available permissions and modules for configuring API keys.

### Example

```ts
import {
  Configuration,
  APIKeysApi,
} from '';
import type { GetApiApiKeysAvailableOptionsRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new APIKeysApi(config);

  try {
    const data = await api.getApiApiKeysAvailableOptions();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**ApiKeyOptions**](ApiKeyOptions.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Available options |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getApiKey

> GetApiKey200Response getApiKey(id)

Get API Key

Get details of a specific API key.

### Example

```ts
import {
  Configuration,
  APIKeysApi,
} from '';
import type { GetApiKeyRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new APIKeysApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies GetApiKeyRequest;

  try {
    const data = await api.getApiKey(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

[**GetApiKey200Response**](GetApiKey200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | API key details |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiApiKeys

> PostApiApiKeys201Response postApiApiKeys(createApiKeyRequest)

Create API Key

Create a new API key with optional permission and module restrictions.

### Example

```ts
import {
  Configuration,
  APIKeysApi,
} from '';
import type { PostApiApiKeysRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new APIKeysApi(config);

  const body = {
    // CreateApiKeyRequest (optional)
    createApiKeyRequest: ...,
  } satisfies PostApiApiKeysRequest;

  try {
    const data = await api.postApiApiKeys(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **createApiKeyRequest** | [CreateApiKeyRequest](CreateApiKeyRequest.md) |  | [Optional] |

### Return type

[**PostApiApiKeys201Response**](PostApiApiKeys201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | API key created |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## updateApiKey

> GetApiKey200Response updateApiKey(id, updateApiKeyRequest)

Update API Key

Update an API key\&#39;s name, status, permissions, or modules.

### Example

```ts
import {
  Configuration,
  APIKeysApi,
} from '';
import type { UpdateApiKeyOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new APIKeysApi(config);

  const body = {
    // string
    id: id_example,
    // UpdateApiKeyRequest (optional)
    updateApiKeyRequest: ...,
  } satisfies UpdateApiKeyOperationRequest;

  try {
    const data = await api.updateApiKey(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |
| **updateApiKeyRequest** | [UpdateApiKeyRequest](UpdateApiKeyRequest.md) |  | [Optional] |

### Return type

[**GetApiKey200Response**](GetApiKey200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | API key updated |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

