# CalculationsApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**postApiCalcChineseForecast**](CalculationsApi.md#postapicalcchineseforecast) | **POST** /api/calc/chinese-forecast | Chinese Zodiac Forecast |
| [**postApiCalcChineseHoroscope**](CalculationsApi.md#postapicalcchinesehoroscope) | **POST** /api/calc/chinese-horoscope | Chinese Zodiac Sign |
| [**postApiCalcCompatibility**](CalculationsApi.md#postapicalccompatibility) | **POST** /api/calc/compatibility | Compatibility Analysis |
| [**postApiCalcComposite**](CalculationsApi.md#postapicalccomposite) | **POST** /api/calc/composite | Composite Chart |
| [**postApiCalcLunarReturn**](CalculationsApi.md#postapicalclunarreturn) | **POST** /api/calc/lunar-return | Lunar Return |
| [**postApiCalcMoonSun**](CalculationsApi.md#postapicalcmoonsun) | **POST** /api/calc/moon-sun | Moon &amp; Sun Info |
| [**postApiCalcNatal**](CalculationsApi.md#postapicalcnatal) | **POST** /api/calc/natal | Natal Chart |
| [**postApiCalcProgressions**](CalculationsApi.md#postapicalcprogressions) | **POST** /api/calc/progressions | Secondary Progressions |
| [**postApiCalcSolarReturn**](CalculationsApi.md#postapicalcsolarreturn) | **POST** /api/calc/solar-return | Solar Return |
| [**postApiCalcSynastry**](CalculationsApi.md#postapicalcsynastry) | **POST** /api/calc/synastry | Synastry Chart |
| [**postApiCalcTransit**](CalculationsApi.md#postapicalctransit) | **POST** /api/calc/transit | Transit Chart |



## postApiCalcChineseForecast

> ChineseForecastResponse postApiCalcChineseForecast(chineseForecastRequest)

Chinese Zodiac Forecast

Get Chinese zodiac forecast for a specific year with category breakdowns.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcChineseForecastRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // ChineseForecastRequest (optional)
    chineseForecastRequest: ...,
  } satisfies PostApiCalcChineseForecastRequest;

  try {
    const data = await api.postApiCalcChineseForecast(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chineseForecastRequest** | [ChineseForecastRequest](ChineseForecastRequest.md) |  | [Optional] |

### Return type

[**ChineseForecastResponse**](ChineseForecastResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate Chinese horoscope forecast |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcChineseHoroscope

> ChineseHoroscopeResponse postApiCalcChineseHoroscope(chineseHoroscopeRequest)

Chinese Zodiac Sign

Calculate the Chinese zodiac sign and element based on birth year.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcChineseHoroscopeRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // ChineseHoroscopeRequest (optional)
    chineseHoroscopeRequest: ...,
  } satisfies PostApiCalcChineseHoroscopeRequest;

  try {
    const data = await api.postApiCalcChineseHoroscope(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chineseHoroscopeRequest** | [ChineseHoroscopeRequest](ChineseHoroscopeRequest.md) |  | [Optional] |

### Return type

[**ChineseHoroscopeResponse**](ChineseHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate Chinese horoscope sign |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcCompatibility

> CompatibilityResponse postApiCalcCompatibility(compatibilityRequest)

Compatibility Analysis

Calculate sun sign compatibility between two people with interpretation text.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcCompatibilityRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // CompatibilityRequest (optional)
    compatibilityRequest: ...,
  } satisfies PostApiCalcCompatibilityRequest;

  try {
    const data = await api.postApiCalcCompatibility(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **compatibilityRequest** | [CompatibilityRequest](CompatibilityRequest.md) |  | [Optional] |

### Return type

[**CompatibilityResponse**](CompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate compatibility between two birth charts |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcComposite

> CompositeResponse postApiCalcComposite(compositeRequest)

Composite Chart

Calculate a composite chart by combining midpoints of two birth charts.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcCompositeRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // CompositeRequest (optional)
    compositeRequest: ...,
  } satisfies PostApiCalcCompositeRequest;

  try {
    const data = await api.postApiCalcComposite(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **compositeRequest** | [CompositeRequest](CompositeRequest.md) |  | [Optional] |

### Return type

[**CompositeResponse**](CompositeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate composite chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcLunarReturn

> LunarReturnResponse postApiCalcLunarReturn(lunarReturnRequest)

Lunar Return

Calculate the lunar return chart when the Moon returns to its natal position.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcLunarReturnRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // LunarReturnRequest (optional)
    lunarReturnRequest: ...,
  } satisfies PostApiCalcLunarReturnRequest;

  try {
    const data = await api.postApiCalcLunarReturn(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **lunarReturnRequest** | [LunarReturnRequest](LunarReturnRequest.md) |  | [Optional] |

### Return type

[**LunarReturnResponse**](LunarReturnResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate lunar return chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcMoonSun

> MoonSunResponse postApiCalcMoonSun(moonSunRequest)

Moon &amp; Sun Info

Get Moon and Sun information for a specific place and time. Includes moon phase, illumination, distance, and sun rise/set/twilight times.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcMoonSunRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // MoonSunRequest (optional)
    moonSunRequest: ...,
  } satisfies PostApiCalcMoonSunRequest;

  try {
    const data = await api.postApiCalcMoonSun(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **moonSunRequest** | [MoonSunRequest](MoonSunRequest.md) |  | [Optional] |

### Return type

[**MoonSunResponse**](MoonSunResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Moon and Sun information |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcNatal

> NatalResponse postApiCalcNatal(natalRequest)

Natal Chart

Calculate a natal (birth) chart with planetary positions, house cusps, and aspects.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcNatalRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // NatalRequest (optional)
    natalRequest: ...,
  } satisfies PostApiCalcNatalRequest;

  try {
    const data = await api.postApiCalcNatal(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **natalRequest** | [NatalRequest](NatalRequest.md) |  | [Optional] |

### Return type

[**NatalResponse**](NatalResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate natal chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcProgressions

> ProgressionsResponse postApiCalcProgressions(progressionsRequest)

Secondary Progressions

Calculate secondary progressions chart using the day-for-a-year method. Returns progressed planet positions and aspects to both progressed and natal planets.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcProgressionsRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // ProgressionsRequest (optional)
    progressionsRequest: ...,
  } satisfies PostApiCalcProgressionsRequest;

  try {
    const data = await api.postApiCalcProgressions(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **progressionsRequest** | [ProgressionsRequest](ProgressionsRequest.md) |  | [Optional] |

### Return type

[**ProgressionsResponse**](ProgressionsResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate secondary progressions chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcSolarReturn

> SolarReturnResponse postApiCalcSolarReturn(solarReturnRequest)

Solar Return

Calculate the solar return chart for a specific year (birthday chart).

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcSolarReturnRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // SolarReturnRequest (optional)
    solarReturnRequest: ...,
  } satisfies PostApiCalcSolarReturnRequest;

  try {
    const data = await api.postApiCalcSolarReturn(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **solarReturnRequest** | [SolarReturnRequest](SolarReturnRequest.md) |  | [Optional] |

### Return type

[**SolarReturnResponse**](SolarReturnResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate solar return chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcSynastry

> SynastryResponse postApiCalcSynastry(synastryRequest)

Synastry Chart

Calculate synastry aspects between two birth charts for relationship analysis.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcSynastryRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // SynastryRequest (optional)
    synastryRequest: ...,
  } satisfies PostApiCalcSynastryRequest;

  try {
    const data = await api.postApiCalcSynastry(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **synastryRequest** | [SynastryRequest](SynastryRequest.md) |  | [Optional] |

### Return type

[**SynastryResponse**](SynastryResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate synastry chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiCalcTransit

> TransitResponse postApiCalcTransit(transitRequest)

Transit Chart

Calculate planetary transits over a natal chart for a specified time period.

### Example

```ts
import {
  Configuration,
  CalculationsApi,
} from '';
import type { PostApiCalcTransitRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new CalculationsApi(config);

  const body = {
    // TransitRequest (optional)
    transitRequest: ...,
  } satisfies PostApiCalcTransitRequest;

  try {
    const data = await api.postApiCalcTransit(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **transitRequest** | [TransitRequest](TransitRequest.md) |  | [Optional] |

### Return type

[**TransitResponse**](TransitResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Calculate transits chart |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

