# ChatApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**chat**](ChatApi.md#chatoperation) | **POST** /api/chat/{chatbotId} | Chat with Chatbot |
| [**chatDirect**](ChatApi.md#chatdirectoperation) | **POST** /api/chat/{chatbotId}/direct | Chat with Birth Data |
| [**chatWithProfile**](ChatApi.md#chatwithprofile) | **POST** /api/chat/{chatbotId}/profile/{profileId} | Chat with Profile |
| [**deleteConversation**](ChatApi.md#deleteconversation) | **DELETE** /api/chat/{chatbotId}/conversation/{conversationId} | Delete Conversation |
| [**getConversation**](ChatApi.md#getconversation) | **GET** /api/chat/{chatbotId}/conversation/{conversationId} | Get Conversation |



## chat

> any chat(chatbotId, chatRequest)

Chat with Chatbot

Send a message to a chatbot and receive a streaming response via SSE

### Example

```ts
import {
  Configuration,
  ChatApi,
} from '';
import type { ChatOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
    // ChatRequest (optional)
    chatRequest: ...,
  } satisfies ChatOperationRequest;

  try {
    const data = await api.chat(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |
| **chatRequest** | [ChatRequest](ChatRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | SSE stream with chat response |  -  |
| **404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## chatDirect

> any chatDirect(chatbotId, chatDirectRequest)

Chat with Birth Data

Send a message with inline birth data (no profile needed)

### Example

```ts
import {
  Configuration,
  ChatApi,
} from '';
import type { ChatDirectOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
    // ChatDirectRequest (optional)
    chatDirectRequest: ...,
  } satisfies ChatDirectOperationRequest;

  try {
    const data = await api.chatDirect(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |
| **chatDirectRequest** | [ChatDirectRequest](ChatDirectRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | SSE stream with chat response |  -  |
| **404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## chatWithProfile

> any chatWithProfile(chatbotId, profileId, chatRequest)

Chat with Profile

Send a message using a pre-configured user profile

### Example

```ts
import {
  Configuration,
  ChatApi,
} from '';
import type { ChatWithProfileRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
    // string
    profileId: profileId_example,
    // ChatRequest (optional)
    chatRequest: ...,
  } satisfies ChatWithProfileRequest;

  try {
    const data = await api.chatWithProfile(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |
| **profileId** | `string` |  | [Defaults to `undefined`] |
| **chatRequest** | [ChatRequest](ChatRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | SSE stream with chat response |  -  |
| **404** | Chatbot or profile not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## deleteConversation

> deleteConversation(chatbotId, conversationId)

Delete Conversation

Delete a conversation and its history

### Example

```ts
import {
  Configuration,
  ChatApi,
} from '';
import type { DeleteConversationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
    // string
    conversationId: conversationId_example,
  } satisfies DeleteConversationRequest;

  try {
    const data = await api.deleteConversation(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |
| **conversationId** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Conversation deleted |  -  |
| **404** | Conversation not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getConversation

> getConversation(chatbotId, conversationId)

Get Conversation

Retrieve conversation history

### Example

```ts
import {
  Configuration,
  ChatApi,
} from '';
import type { GetConversationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
    // string
    conversationId: conversationId_example,
  } satisfies GetConversationRequest;

  try {
    const data = await api.getConversation(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |
| **conversationId** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Conversation data |  -  |
| **404** | Conversation not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

