# ChatbotApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createChatProfile**](ChatbotApi.md#createchatprofileoperation) | **POST** /api/chatbots/{id}/profiles | Create Chat Profile |
| [**createChatbot**](ChatbotApi.md#createchatbotoperation) | **POST** /api/chatbots | Create Chatbot |
| [**deleteChatProfile**](ChatbotApi.md#deletechatprofile) | **DELETE** /api/chatbots/{id}/profiles/{profileId} | Delete Chat Profile |
| [**deleteChatbot**](ChatbotApi.md#deletechatbot) | **DELETE** /api/chatbots/{id} | Delete Chatbot |
| [**getChatbot**](ChatbotApi.md#getchatbot) | **GET** /api/chatbots/{id} | Get Chatbot |
| [**getChatbotUsage**](ChatbotApi.md#getchatbotusage) | **GET** /api/chatbots/usage | Get Chatbot Usage |
| [**listChatProfiles**](ChatbotApi.md#listchatprofiles) | **GET** /api/chatbots/{id}/profiles | List Chat Profiles |
| [**listChatbotPlugins**](ChatbotApi.md#listchatbotplugins) | **GET** /api/chatbots/plugins | List Available Plugins |
| [**listChatbots**](ChatbotApi.md#listchatbots) | **GET** /api/chatbots | List Chatbots |
| [**updateChatbot**](ChatbotApi.md#updatechatbotoperation) | **PATCH** /api/chatbots/{id} | Update Chatbot |



## createChatProfile

> any createChatProfile(id, createChatProfileRequest)

Create Chat Profile

Create a pre-configured chat profile with birth data

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { CreateChatProfileOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  const body = {
    // string
    id: id_example,
    // CreateChatProfileRequest (optional)
    createChatProfileRequest: ...,
  } satisfies CreateChatProfileOperationRequest;

  try {
    const data = await api.createChatProfile(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |
| **createChatProfileRequest** | [CreateChatProfileRequest](CreateChatProfileRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created profile |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## createChatbot

> any createChatbot(createChatbotRequest)

Create Chatbot

Create a new chatbot for the organization

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { CreateChatbotOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  const body = {
    // CreateChatbotRequest (optional)
    createChatbotRequest: ...,
  } satisfies CreateChatbotOperationRequest;

  try {
    const data = await api.createChatbot(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **createChatbotRequest** | [CreateChatbotRequest](CreateChatbotRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Created chatbot |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## deleteChatProfile

> deleteChatProfile(id, profileId)

Delete Chat Profile

Delete a chat profile

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { DeleteChatProfileRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  const body = {
    // string
    id: id_example,
    // string
    profileId: profileId_example,
  } satisfies DeleteChatProfileRequest;

  try {
    const data = await api.deleteChatProfile(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |
| **profileId** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Profile deleted |  -  |
| **404** | Profile not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## deleteChatbot

> deleteChatbot(id)

Delete Chatbot

Delete a chatbot

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { DeleteChatbotRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies DeleteChatbotRequest;

  try {
    const data = await api.deleteChatbot(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Chatbot deleted |  -  |
| **404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getChatbot

> any getChatbot(id)

Get Chatbot

Get a specific chatbot by ID

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { GetChatbotRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies GetChatbotRequest;

  try {
    const data = await api.getChatbot(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Chatbot details |  -  |
| **404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getChatbotUsage

> any getChatbotUsage()

Get Chatbot Usage

Get chatbot usage statistics for the current organization

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { GetChatbotUsageRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  try {
    const data = await api.getChatbotUsage();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Usage statistics |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## listChatProfiles

> any listChatProfiles(id)

List Chat Profiles

List all chat profiles for a chatbot

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { ListChatProfilesRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies ListChatProfilesRequest;

  try {
    const data = await api.listChatProfiles(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of profiles |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## listChatbotPlugins

> any listChatbotPlugins()

List Available Plugins

List all available chatbot plugins

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { ListChatbotPluginsRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  try {
    const data = await api.listChatbotPlugins();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of plugins |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## listChatbots

> any listChatbots()

List Chatbots

List all chatbots for the current organization

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { ListChatbotsRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  try {
    const data = await api.listChatbots();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List of chatbots |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## updateChatbot

> any updateChatbot(id, updateChatbotRequest)

Update Chatbot

Update an existing chatbot

### Example

```ts
import {
  Configuration,
  ChatbotApi,
} from '';
import type { UpdateChatbotOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ChatbotApi(config);

  const body = {
    // string
    id: id_example,
    // UpdateChatbotRequest (optional)
    updateChatbotRequest: ...,
  } satisfies UpdateChatbotOperationRequest;

  try {
    const data = await api.updateChatbot(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |
| **updateChatbotRequest** | [UpdateChatbotRequest](UpdateChatbotRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Updated chatbot |  -  |
| **404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

