# ContentApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**createContent**](ContentApi.md#createcontent) | **POST** /api/content/{horoscopeType}/{contentType} | Create Content |
| [**createContentCustomCopy**](ContentApi.md#createcontentcustomcopy) | **POST** /api/content/{id}/create-custom-copy | Create Custom Copy |
| [**deleteContent**](ContentApi.md#deletecontent) | **DELETE** /api/content/{horoscopeType}/{contentType}/{id} | Delete Content |
| [**deleteContentById**](ContentApi.md#deletecontentbyid) | **DELETE** /api/content/{id} | Delete Content by ID |
| [**getContent**](ContentApi.md#getcontent) | **GET** /api/content/{horoscopeType}/{contentType}/{id} | Get Content |
| [**listContent**](ContentApi.md#listcontent) | **GET** /api/content/{horoscopeType}/{contentType} | List Content |
| [**restoreContent**](ContentApi.md#restorecontent) | **POST** /api/content/{id}/restore | Restore Content |



## createContent

> ContentResponse createContent(horoscopeType, contentType)

Create Content

Create a new content item for a specific horoscope and content type.

### Example

```ts
import {
  Configuration,
  ContentApi,
} from '';
import type { CreateContentRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ContentApi(config);

  const body = {
    // string
    horoscopeType: horoscopeType_example,
    // string
    contentType: contentType_example,
  } satisfies CreateContentRequest;

  try {
    const data = await api.createContent(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **horoscopeType** | `string` |  | [Defaults to `undefined`] |
| **contentType** | `string` |  | [Defaults to `undefined`] |

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Create content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## createContentCustomCopy

> ContentResponse createContentCustomCopy(id)

Create Custom Copy

Create an organization-specific copy of system content for customization.

### Example

```ts
import {
  Configuration,
  ContentApi,
} from '';
import type { CreateContentCustomCopyRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ContentApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies CreateContentCustomCopyRequest;

  try {
    const data = await api.createContentCustomCopy(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Create a custom copy of system content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## deleteContent

> deleteContent(id, horoscopeType, contentType)

Delete Content

Delete a content item by horoscope type, content type, and ID.

### Example

```ts
import {
  Configuration,
  ContentApi,
} from '';
import type { DeleteContentRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ContentApi(config);

  const body = {
    // string
    id: id_example,
    // string
    horoscopeType: horoscopeType_example,
    // string
    contentType: contentType_example,
  } satisfies DeleteContentRequest;

  try {
    const data = await api.deleteContent(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |
| **horoscopeType** | `string` |  | [Defaults to `undefined`] |
| **contentType** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Delete one content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## deleteContentById

> ContentResponse deleteContentById(id)

Delete Content by ID

Delete a content item by its ID.

### Example

```ts
import {
  Configuration,
  ContentApi,
} from '';
import type { DeleteContentByIdRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ContentApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies DeleteContentByIdRequest;

  try {
    const data = await api.deleteContentById(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Delete one content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getContent

> ContentResponse getContent(id, horoscopeType, contentType)

Get Content

Retrieve a single content item by its ID.

### Example

```ts
import {
  Configuration,
  ContentApi,
} from '';
import type { GetContentRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ContentApi(config);

  const body = {
    // string
    id: id_example,
    // string
    horoscopeType: horoscopeType_example,
    // string
    contentType: contentType_example,
  } satisfies GetContentRequest;

  try {
    const data = await api.getContent(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |
| **horoscopeType** | `string` |  | [Defaults to `undefined`] |
| **contentType** | `string` |  | [Defaults to `undefined`] |

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Retrieve one content item |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## listContent

> ContentResponse listContent(horoscopeType, contentType)

List Content

Retrieve a paginated list of content items filtered by horoscope and content type.

### Example

```ts
import {
  Configuration,
  ContentApi,
} from '';
import type { ListContentRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ContentApi(config);

  const body = {
    // string
    horoscopeType: horoscopeType_example,
    // string
    contentType: contentType_example,
  } satisfies ListContentRequest;

  try {
    const data = await api.listContent(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **horoscopeType** | `string` |  | [Defaults to `undefined`] |
| **contentType** | `string` |  | [Defaults to `undefined`] |

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Retrieve content items |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## restoreContent

> ContentResponse restoreContent(id)

Restore Content

Restore custom content to match the original system content.

### Example

```ts
import {
  Configuration,
  ContentApi,
} from '';
import type { RestoreContentRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ContentApi(config);

  const body = {
    // string
    id: id_example,
  } satisfies RestoreContentRequest;

  try {
    const data = await api.restoreContent(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | `string` |  | [Defaults to `undefined`] |

### Return type

[**ContentResponse**](ContentResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Restore custom content to match system content |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

