# HoroscopeApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getDailyHoroscopes**](HoroscopeApi.md#getdailyhoroscopes) | **GET** /api/horoscope/daily/{date} | Get Daily Horoscopes |
| [**getWeeklyHoroscope**](HoroscopeApi.md#getweeklyhoroscope) | **GET** /api/horoscope/weekly/{year}/{week}/{zodiacSign} | Get Weekly Horoscope Report |
| [**getYearlyAscendantHoroscope**](HoroscopeApi.md#getyearlyascendanthoroscope) | **GET** /api/horoscope/yearly-ascendant/{year}/{zodiacSign} | Get Yearly Ascendant Horoscope Report |
| [**getYearlyHoroscope**](HoroscopeApi.md#getyearlyhoroscope) | **GET** /api/horoscope/yearly/{year}/{zodiacSign} | Get Yearly Horoscope Report |



## getDailyHoroscopes

> DailyHoroscopeResponse getDailyHoroscopes(date)

Get Daily Horoscopes

Retrieve daily horoscopes for all zodiac signs for a specific date.

### Example

```ts
import {
  Configuration,
  HoroscopeApi,
} from '';
import type { GetDailyHoroscopesRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new HoroscopeApi(config);

  const body = {
    // string
    date: date_example,
  } satisfies GetDailyHoroscopesRequest;

  try {
    const data = await api.getDailyHoroscopes(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **date** | `string` |  | [Defaults to `undefined`] |

### Return type

[**DailyHoroscopeResponse**](DailyHoroscopeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Daily horoscopes for all zodiac signs |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getWeeklyHoroscope

> HoroscopeReportResponse getWeeklyHoroscope(year, week, zodiacSign)

Get Weekly Horoscope Report

Retrieve weekly horoscope report for a specific zodiac sign and week.

### Example

```ts
import {
  Configuration,
  HoroscopeApi,
} from '';
import type { GetWeeklyHoroscopeRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new HoroscopeApi(config);

  const body = {
    // string
    year: year_example,
    // string
    week: week_example,
    // string
    zodiacSign: zodiacSign_example,
  } satisfies GetWeeklyHoroscopeRequest;

  try {
    const data = await api.getWeeklyHoroscope(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **year** | `string` |  | [Defaults to `undefined`] |
| **week** | `string` |  | [Defaults to `undefined`] |
| **zodiacSign** | `string` |  | [Defaults to `undefined`] |

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Weekly horoscope report |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getYearlyAscendantHoroscope

> HoroscopeReportResponse getYearlyAscendantHoroscope(year, zodiacSign)

Get Yearly Ascendant Horoscope Report

Retrieve yearly horoscope report for a specific ascendant sign and year.

### Example

```ts
import {
  Configuration,
  HoroscopeApi,
} from '';
import type { GetYearlyAscendantHoroscopeRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new HoroscopeApi(config);

  const body = {
    // string
    year: year_example,
    // string
    zodiacSign: zodiacSign_example,
  } satisfies GetYearlyAscendantHoroscopeRequest;

  try {
    const data = await api.getYearlyAscendantHoroscope(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **year** | `string` |  | [Defaults to `undefined`] |
| **zodiacSign** | `string` |  | [Defaults to `undefined`] |

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Yearly ascendant horoscope report |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getYearlyHoroscope

> HoroscopeReportResponse getYearlyHoroscope(year, zodiacSign)

Get Yearly Horoscope Report

Retrieve yearly horoscope report for a specific zodiac sign and year.

### Example

```ts
import {
  Configuration,
  HoroscopeApi,
} from '';
import type { GetYearlyHoroscopeRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new HoroscopeApi(config);

  const body = {
    // string
    year: year_example,
    // string
    zodiacSign: zodiacSign_example,
  } satisfies GetYearlyHoroscopeRequest;

  try {
    const data = await api.getYearlyHoroscope(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **year** | `string` |  | [Defaults to `undefined`] |
| **zodiacSign** | `string` |  | [Defaults to `undefined`] |

### Return type

[**HoroscopeReportResponse**](HoroscopeReportResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Yearly horoscope report |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

