# ModulesApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getApiModules**](ModulesApi.md#getapimodules) | **GET** /api/modules | List Modules |
| [**getApiModulesCheckModuleId**](ModulesApi.md#getapimodulescheckmoduleid) | **GET** /api/modules/check/{moduleId} | Check Module Access |
| [**getApiModulesOrganization**](ModulesApi.md#getapimodulesorganization) | **GET** /api/modules/organization | Organization Modules |
| [**getApiModulesPlans**](ModulesApi.md#getapimodulesplans) | **GET** /api/modules/plans | Subscription Plans |



## getApiModules

> GetApiModules200Response getApiModules()

List Modules

Get all available modules with pricing information.

### Example

```ts
import {
  Configuration,
  ModulesApi,
} from '';
import type { GetApiModulesRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ModulesApi(config);

  try {
    const data = await api.getApiModules();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModules200Response**](GetApiModules200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List all available modules |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getApiModulesCheckModuleId

> ModuleAccessCheck getApiModulesCheckModuleId(moduleId)

Check Module Access

Check if the current organization has access to a specific module.

### Example

```ts
import {
  Configuration,
  ModulesApi,
} from '';
import type { GetApiModulesCheckModuleIdRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ModulesApi(config);

  const body = {
    // string
    moduleId: moduleId_example,
  } satisfies GetApiModulesCheckModuleIdRequest;

  try {
    const data = await api.getApiModulesCheckModuleId(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **moduleId** | `string` |  | [Defaults to `undefined`] |

### Return type

[**ModuleAccessCheck**](ModuleAccessCheck.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Check module access |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getApiModulesOrganization

> GetApiModulesOrganization200Response getApiModulesOrganization()

Organization Modules

Get the list of modules the current organization has access to.

### Example

```ts
import {
  Configuration,
  ModulesApi,
} from '';
import type { GetApiModulesOrganizationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ModulesApi(config);

  try {
    const data = await api.getApiModulesOrganization();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModulesOrganization200Response**](GetApiModulesOrganization200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List modules for current organization |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getApiModulesPlans

> GetApiModulesPlans200Response getApiModulesPlans()

Subscription Plans

Get all available subscription plans with included modules and pricing.

### Example

```ts
import {
  Configuration,
  ModulesApi,
} from '';
import type { GetApiModulesPlansRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new ModulesApi(config);

  try {
    const data = await api.getApiModulesPlans();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiModulesPlans200Response**](GetApiModulesPlans200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List all subscription plans |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

