# NumerologyApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**postApiNumerologyBirthday**](NumerologyApi.md#postapinumerologybirthday) | **POST** /api/numerology/birthday | Birthday Number |
| [**postApiNumerologyCompatibility**](NumerologyApi.md#postapinumerologycompatibility) | **POST** /api/numerology/compatibility | Numerology Compatibility |
| [**postApiNumerologyExpression**](NumerologyApi.md#postapinumerologyexpression) | **POST** /api/numerology/expression | Expression Number |
| [**postApiNumerologyLifePath**](NumerologyApi.md#postapinumerologylifepath) | **POST** /api/numerology/life-path | Life Path Number |
| [**postApiNumerologyPersonalCycles**](NumerologyApi.md#postapinumerologypersonalcycles) | **POST** /api/numerology/personal-cycles | Personal Cycles |
| [**postApiNumerologyPersonality**](NumerologyApi.md#postapinumerologypersonality) | **POST** /api/numerology/personality | Personality Number |
| [**postApiNumerologyProfile**](NumerologyApi.md#postapinumerologyprofile) | **POST** /api/numerology/profile | Full Numerology Profile |
| [**postApiNumerologySoulUrge**](NumerologyApi.md#postapinumerologysoulurge) | **POST** /api/numerology/soul-urge | Soul Urge Number |



## postApiNumerologyBirthday

> NumerologyBirthdayResponse postApiNumerologyBirthday(numerologyBirthdayRequest)

Birthday Number

Calculate the Birthday Number from the day of birth. This number represents a special talent you possess.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologyBirthdayRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologyBirthdayRequest (optional)
    numerologyBirthdayRequest: ...,
  } satisfies PostApiNumerologyBirthdayRequest;

  try {
    const data = await api.postApiNumerologyBirthday(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologyBirthdayRequest** | [NumerologyBirthdayRequest](NumerologyBirthdayRequest.md) |  | [Optional] |

### Return type

[**NumerologyBirthdayResponse**](NumerologyBirthdayResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Birthday number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiNumerologyCompatibility

> NumerologyCompatibilityResponse postApiNumerologyCompatibility(numerologyCompatibilityRequest)

Numerology Compatibility

Calculate compatibility between two people based on their Life Path numbers.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologyCompatibilityRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologyCompatibilityRequest (optional)
    numerologyCompatibilityRequest: ...,
  } satisfies PostApiNumerologyCompatibilityRequest;

  try {
    const data = await api.postApiNumerologyCompatibility(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologyCompatibilityRequest** | [NumerologyCompatibilityRequest](NumerologyCompatibilityRequest.md) |  | [Optional] |

### Return type

[**NumerologyCompatibilityResponse**](NumerologyCompatibilityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Compatibility calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiNumerologyExpression

> NumerologyExpressionResponse postApiNumerologyExpression(numerologyExpressionRequest)

Expression Number

Calculate the Expression (Destiny) Number from full name. This number reveals your natural talents and abilities.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologyExpressionRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologyExpressionRequest (optional)
    numerologyExpressionRequest: ...,
  } satisfies PostApiNumerologyExpressionRequest;

  try {
    const data = await api.postApiNumerologyExpression(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologyExpressionRequest** | [NumerologyExpressionRequest](NumerologyExpressionRequest.md) |  | [Optional] |

### Return type

[**NumerologyExpressionResponse**](NumerologyExpressionResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Expression number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiNumerologyLifePath

> NumerologyLifePathResponse postApiNumerologyLifePath(numerologyLifePathRequest)

Life Path Number

Calculate the Life Path Number from birth date. This is the most important number in numerology, representing your life\&#39;s purpose.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologyLifePathRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologyLifePathRequest (optional)
    numerologyLifePathRequest: ...,
  } satisfies PostApiNumerologyLifePathRequest;

  try {
    const data = await api.postApiNumerologyLifePath(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologyLifePathRequest** | [NumerologyLifePathRequest](NumerologyLifePathRequest.md) |  | [Optional] |

### Return type

[**NumerologyLifePathResponse**](NumerologyLifePathResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Life Path number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiNumerologyPersonalCycles

> NumerologyPersonalCyclesResponse postApiNumerologyPersonalCycles(numerologyPersonalCyclesRequest)

Personal Cycles

Calculate Personal Year, Month, and Day numbers. These reveal the current energetic influences in your life.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologyPersonalCyclesRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologyPersonalCyclesRequest (optional)
    numerologyPersonalCyclesRequest: ...,
  } satisfies PostApiNumerologyPersonalCyclesRequest;

  try {
    const data = await api.postApiNumerologyPersonalCycles(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologyPersonalCyclesRequest** | [NumerologyPersonalCyclesRequest](NumerologyPersonalCyclesRequest.md) |  | [Optional] |

### Return type

[**NumerologyPersonalCyclesResponse**](NumerologyPersonalCyclesResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Personal cycles calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiNumerologyPersonality

> NumerologyPersonalityResponse postApiNumerologyPersonality(numerologyPersonalityRequest)

Personality Number

Calculate the Personality Number from consonants in the name. This number reveals how others perceive you.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologyPersonalityRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologyPersonalityRequest (optional)
    numerologyPersonalityRequest: ...,
  } satisfies PostApiNumerologyPersonalityRequest;

  try {
    const data = await api.postApiNumerologyPersonality(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologyPersonalityRequest** | [NumerologyPersonalityRequest](NumerologyPersonalityRequest.md) |  | [Optional] |

### Return type

[**NumerologyPersonalityResponse**](NumerologyPersonalityResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Personality number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiNumerologyProfile

> NumerologyProfileResponse postApiNumerologyProfile(numerologyProfileRequest)

Full Numerology Profile

Calculate a complete numerology profile including Life Path, Expression, Soul Urge, Personality, Birthday numbers, Personal Cycles, and identify Master/Karmic numbers.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologyProfileRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologyProfileRequest (optional)
    numerologyProfileRequest: ...,
  } satisfies PostApiNumerologyProfileRequest;

  try {
    const data = await api.postApiNumerologyProfile(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologyProfileRequest** | [NumerologyProfileRequest](NumerologyProfileRequest.md) |  | [Optional] |

### Return type

[**NumerologyProfileResponse**](NumerologyProfileResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Complete numerology profile |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiNumerologySoulUrge

> NumerologySoulUrgeResponse postApiNumerologySoulUrge(numerologySoulUrgeRequest)

Soul Urge Number

Calculate the Soul Urge (Heart\&#39;s Desire) Number from vowels in the name. This number reveals your inner motivations.

### Example

```ts
import {
  Configuration,
  NumerologyApi,
} from '';
import type { PostApiNumerologySoulUrgeRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new NumerologyApi(config);

  const body = {
    // NumerologySoulUrgeRequest (optional)
    numerologySoulUrgeRequest: ...,
  } satisfies PostApiNumerologySoulUrgeRequest;

  try {
    const data = await api.postApiNumerologySoulUrge(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **numerologySoulUrgeRequest** | [NumerologySoulUrgeRequest](NumerologySoulUrgeRequest.md) |  | [Optional] |

### Return type

[**NumerologySoulUrgeResponse**](NumerologySoulUrgeResponse.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Soul Urge number calculation |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

