# OrganizationsApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**deleteApiOrgUsersMemberId**](OrganizationsApi.md#deleteapiorgusersmemberid) | **DELETE** /api/org/users/{memberId} | Remove Member |
| [**getApiOrgUsers**](OrganizationsApi.md#getapiorgusers) | **GET** /api/org/users | List Members |
| [**patchApiOrgUsersMemberId**](OrganizationsApi.md#patchapiorgusersmemberidoperation) | **PATCH** /api/org/users/{memberId} | Update Member |
| [**postApiOrg**](OrganizationsApi.md#postapiorg) | **POST** /api/org | Create Organization |
| [**postApiOrgUsers**](OrganizationsApi.md#postapiorgusersoperation) | **POST** /api/org/users | Add Member |



## deleteApiOrgUsersMemberId

> deleteApiOrgUsersMemberId(memberId)

Remove Member

Remove a member from the organization.

### Example

```ts
import {
  Configuration,
  OrganizationsApi,
} from '';
import type { DeleteApiOrgUsersMemberIdRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new OrganizationsApi(config);

  const body = {
    // string
    memberId: memberId_example,
  } satisfies DeleteApiOrgUsersMemberIdRequest;

  try {
    const data = await api.deleteApiOrgUsersMemberId(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **memberId** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Member verwijderd |  -  |
| **400** | Invalid request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Member not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## getApiOrgUsers

> GetApiOrgUsers200Response getApiOrgUsers()

List Members

Get a paginated list of organization members.

### Example

```ts
import {
  Configuration,
  OrganizationsApi,
} from '';
import type { GetApiOrgUsersRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new OrganizationsApi(config);

  try {
    const data = await api.getApiOrgUsers();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**GetApiOrgUsers200Response**](GetApiOrgUsers200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | List organization users |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## patchApiOrgUsersMemberId

> PatchApiOrgUsersMemberId200Response patchApiOrgUsersMemberId(memberId, patchApiOrgUsersMemberIdRequest)

Update Member

Update an organization member\&#39;s role.

### Example

```ts
import {
  Configuration,
  OrganizationsApi,
} from '';
import type { PatchApiOrgUsersMemberIdOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new OrganizationsApi(config);

  const body = {
    // string
    memberId: memberId_example,
    // PatchApiOrgUsersMemberIdRequest (optional)
    patchApiOrgUsersMemberIdRequest: ...,
  } satisfies PatchApiOrgUsersMemberIdOperationRequest;

  try {
    const data = await api.patchApiOrgUsersMemberId(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **memberId** | `string` |  | [Defaults to `undefined`] |
| **patchApiOrgUsersMemberIdRequest** | [PatchApiOrgUsersMemberIdRequest](PatchApiOrgUsersMemberIdRequest.md) |  | [Optional] |

### Return type

[**PatchApiOrgUsersMemberId200Response**](PatchApiOrgUsersMemberId200Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Member geüpdatet |  -  |
| **400** | Invalid request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |
| **404** | Member not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiOrg

> any postApiOrg()

Create Organization

Create a new organization with Stripe billing setup.

### Example

```ts
import {
  Configuration,
  OrganizationsApi,
} from '';
import type { PostApiOrgRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new OrganizationsApi(config);

  try {
    const data = await api.postApiOrg();
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters

This endpoint does not need any parameter.

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Create organization |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## postApiOrgUsers

> PostApiOrgUsers201Response postApiOrgUsers(postApiOrgUsersRequest)

Add Member

Add or invite a new member to the organization.

### Example

```ts
import {
  Configuration,
  OrganizationsApi,
} from '';
import type { PostApiOrgUsersOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new OrganizationsApi(config);

  const body = {
    // PostApiOrgUsersRequest (optional)
    postApiOrgUsersRequest: ...,
  } satisfies PostApiOrgUsersOperationRequest;

  try {
    const data = await api.postApiOrgUsers(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **postApiOrgUsersRequest** | [PostApiOrgUsersRequest](PostApiOrgUsersRequest.md) |  | [Optional] |

### Return type

[**PostApiOrgUsers201Response**](PostApiOrgUsers201Response.md)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/vnd.api+json`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **201** | Member toegevoegd/uitgenodigd |  -  |
| **400** | Invalid request |  -  |
| **401** | Unauthorized |  -  |
| **403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

