# WidgetApi

All URIs are relative to *https://api.astroapi.cloud*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getWidgetConfig**](WidgetApi.md#getwidgetconfig) | **GET** /widget/config/{chatbotId} | Get Widget Configuration |
| [**widgetChat**](WidgetApi.md#widgetchatoperation) | **POST** /widget/chat/{chatbotId} | Widget Chat |
| [**widgetChatWithUser**](WidgetApi.md#widgetchatwithuseroperation) | **POST** /widget/chat/{chatbotId}/user/{externalUserId} | Widget Chat with User Profile |



## getWidgetConfig

> getWidgetConfig(chatbotId)

Get Widget Configuration

Get the widget configuration for embedding

### Example

```ts
import {
  Configuration,
  WidgetApi,
} from '';
import type { GetWidgetConfigRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new WidgetApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
  } satisfies GetWidgetConfigRequest;

  try {
    const data = await api.getWidgetConfig(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |

### Return type

`void` (Empty response body)

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Widget configuration |  -  |
| **404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## widgetChat

> any widgetChat(chatbotId, widgetChatRequest)

Widget Chat

Send a message via widget (SSE streaming response)

### Example

```ts
import {
  Configuration,
  WidgetApi,
} from '';
import type { WidgetChatOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new WidgetApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
    // WidgetChatRequest (optional)
    widgetChatRequest: ...,
  } satisfies WidgetChatOperationRequest;

  try {
    const data = await api.widgetChat(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |
| **widgetChatRequest** | [WidgetChatRequest](WidgetChatRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | SSE stream with chat response |  -  |
| **401** | API key required |  -  |
| **403** | Domain not allowed |  -  |
| **404** | Chatbot not found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)


## widgetChatWithUser

> any widgetChatWithUser(chatbotId, externalUserId, widgetChatWithUserRequest)

Widget Chat with User Profile

Chat using an external user ID (creates profile on first use)

### Example

```ts
import {
  Configuration,
  WidgetApi,
} from '';
import type { WidgetChatWithUserOperationRequest } from '';

async function example() {
  console.log("🚀 Testing  SDK...");
  const config = new Configuration({ 
    // To configure API key authorization: ApiKeyAuth
    apiKey: "YOUR API KEY",
  });
  const api = new WidgetApi(config);

  const body = {
    // string
    chatbotId: chatbotId_example,
    // string
    externalUserId: externalUserId_example,
    // WidgetChatWithUserRequest (optional)
    widgetChatWithUserRequest: ...,
  } satisfies WidgetChatWithUserOperationRequest;

  try {
    const data = await api.widgetChatWithUser(body);
    console.log(data);
  } catch (error) {
    console.error(error);
  }
}

// Run the test
example().catch(console.error);
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **chatbotId** | `string` |  | [Defaults to `undefined`] |
| **externalUserId** | `string` |  | [Defaults to `undefined`] |
| **widgetChatWithUserRequest** | [WidgetChatWithUserRequest](WidgetChatWithUserRequest.md) |  | [Optional] |

### Return type

**any**

### Authorization

[ApiKeyAuth](../README.md#ApiKeyAuth)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `text/event-stream`


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | SSE stream with chat response |  -  |
| **400** | Birth data required for new users |  -  |
| **401** | API key required |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#api-endpoints) [[Back to Model list]](../README.md#models) [[Back to README]](../README.md)

